/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.blocks.base.DetentionBlock;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.entity.base.IDetainableEntity;
import com.lazrproductions.cuffed.init.ModSounds;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class PilloryBlock
extends DetentionBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final BooleanProperty CLOSED = BooleanProperty.m_61465_((String)"closed");
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape SHAPE_NS_CLOSED = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.0, (double)0.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)0.0, (double)6.0, (double)17.0, (double)9.0, (double)10.0), Block.m_49796_((double)2.0, (double)0.0, (double)7.0, (double)14.0, (double)4.0, (double)9.0)});
    protected static final VoxelShape SHAPE_NS_OPEN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.0, (double)0.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)0.0, (double)6.0, (double)17.0, (double)9.0, (double)10.0), Block.m_49796_((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)8.0, (double)9.0)});
    protected static final VoxelShape SHAPE_NS_BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.0, (double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)0.0, (double)6.0, (double)17.0, (double)16.0, (double)10.0), Block.m_49796_((double)2.0, (double)10.0, (double)7.0, (double)14.0, (double)15.0, (double)9.0)});
    protected static final VoxelShape SHAPE_EW_CLOSED = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)14.0, (double)10.0, (double)9.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)0.0, (double)2.0, (double)9.0, (double)4.0, (double)14.0), Block.m_49796_((double)6.0, (double)0.0, (double)-1.0, (double)10.0, (double)9.0, (double)2.0)});
    protected static final VoxelShape SHAPE_EW_OPEN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)14.0, (double)10.0, (double)9.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)3.0, (double)2.0, (double)9.0, (double)8.0, (double)14.0), Block.m_49796_((double)6.0, (double)0.0, (double)-1.0, (double)10.0, (double)9.0, (double)2.0)});
    protected static final VoxelShape SHAPE_EW_BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)14.0, (double)10.0, (double)16.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)-1.0, (double)10.0, (double)16.0, (double)2.0), Block.m_49796_((double)7.0, (double)10.0, (double)2.0, (double)9.0, (double)15.0, (double)14.0)});

    public PilloryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return state.m_61143_((Property)FACING) == Direction.NORTH || state.m_61143_((Property)FACING) == Direction.SOUTH ? SHAPE_NS_BASE : SHAPE_EW_BASE;
        }
        return state.m_61143_((Property)FACING) == Direction.NORTH || state.m_61143_((Property)FACING) == Direction.SOUTH ? (((Boolean)state.m_61143_((Property)CLOSED)).booleanValue() ? SHAPE_NS_CLOSED : SHAPE_NS_OPEN) : ((Boolean)state.m_61143_((Property)CLOSED) != false ? SHAPE_EW_CLOSED : SHAPE_EW_OPEN);
    }

    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        return this.m_5940_(state, getter, pos, ctx);
    }

    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation r) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)r.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror m) {
        return state.m_60717_(m.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState otherState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        DoubleBlockHalf thisHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && thisHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return otherState.m_60713_((Block)this) && otherState.m_61143_(HALF) != thisHalf ? (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)otherState.m_61143_((Property)FACING)))).m_61124_((Property)CLOSED, (Comparable)((Boolean)otherState.m_61143_((Property)CLOSED))) : Blocks.f_50016_.m_49966_();
        }
        return thisHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            PilloryBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HALF, CLOSED});
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        IDetainableEntity en = (IDetainableEntity)player;
        if (en.getDetained() > -1) {
            return InteractionResult.FAIL;
        }
        if (!player.m_6047_() && state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            if (!level.f_46443_) {
                BlockState state1 = level.m_8055_(pos.m_7494_());
                state.m_60734_().m_6227_(state1, level, pos.m_7494_(), player, hand, hit);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_() && !level.f_46443_) {
            boolean wasOpen = !this.getClosed(state);
            boolean shouldBeOpen = this.attemptToToggleDetained(level, wasOpen, state, pos);
            if (shouldBeOpen != wasOpen) {
                Random r = new Random();
                level.m_5594_(null, pos, ModSounds.PILLORY_USE, SoundSource.BLOCKS, 1.0f, ((Boolean)state.m_61143_((Property)CLOSED) != false ? 1.0f : 0.8f) + r.nextFloat() * 0.1f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(!shouldBeOpen)), 11);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_() && state.m_61143_(HALF) == DoubleBlockHalf.UPPER && level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setClosed(Level level, BlockPos pos, BlockState state, boolean v) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(v)), 1);
    }

    public boolean getClosed(BlockState state) {
        return (Boolean)state.m_61143_((Property)CLOSED);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60713_(state.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockpos, blockstate1, 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public float getFacingRotation(BlockState state, BlockPos pos) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_();
    }

    public static Vec3 getPositionBehind(BlockState state, BlockPos pos) {
        double xOffset;
        double d = state.m_61143_((Property)FACING) == Direction.EAST ? -0.363 : (xOffset = state.m_61143_((Property)FACING) == Direction.WEST ? 0.363 : 0.0);
        double zOffset = state.m_61143_((Property)FACING) == Direction.SOUTH ? -0.363 : (state.m_61143_((Property)FACING) == Direction.NORTH ? 0.363 : 0.0);
        return pos.m_252807_().m_82549_(new Vec3(xOffset, -1.5, zOffset));
    }

    public boolean attemptToToggleDetained(@Nonnull Level level, boolean wasOpen, BlockState state, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            double dist;
            Vec3 behind = PilloryBlock.getPositionBehind(state, pos);
            Player p = level.m_45941_(TargetingConditions.m_148353_(), behind.f_82479_, behind.f_82480_, behind.f_82481_);
            if (p != null && (dist = Math.sqrt(Math.pow(behind.f_82481_ - p.m_20182_().f_82481_, 2.0) + Math.pow(behind.f_82479_ - p.m_20182_().f_82479_, 2.0))) < (double)0.3f) {
                IDetainableEntity detainableEntity = (IDetainableEntity)p;
                if (!wasOpen) {
                    if (detainableEntity.getDetained() == 0) {
                        detainableEntity.undetain();
                        return true;
                    }
                } else {
                    if (detainableEntity.getDetained() == -1 && this.canDetainPlayer(level, state, pos, p, true)) {
                        detainableEntity.detainToBlock(level, new Vector3f((float)behind.m_7096_(), (float)behind.m_7098_(), (float)behind.m_7094_()), pos, 0, this.getFacingRotation(state, pos));
                        return false;
                    }
                    return true;
                }
            }
        }
        return !wasOpen;
    }

    public static Player getDetainedEntity(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        double dist;
        IDetainableEntity detain;
        Vec3 behind = PilloryBlock.getPositionBehind(state, pos);
        Player p = level.m_45941_(TargetingConditions.m_148353_(), behind.f_82479_, behind.f_82480_, behind.f_82481_);
        if (p != null && (detain = (IDetainableEntity)p).getDetained() > -1 && (dist = Math.sqrt(Math.pow(behind.f_82481_ - p.m_20182_().f_82481_, 2.0) + Math.pow(behind.f_82479_ - p.m_20182_().f_82479_, 2.0))) < (double)0.3f) {
            return p;
        }
        return null;
    }

    @Override
    public boolean canDetainPlayer(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Player player, boolean ignoreState) {
        IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability(player);
        if (cap.armsRestrained()) {
            return false;
        }
        return this.getClosed(state) || ignoreState;
    }
}

