/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks.entity;

import com.lazrproductions.cuffed.init.ModBlockEntities;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LockableBlockEntity
extends BlockEntity {
    private UUID lockId = UUID.randomUUID();
    private boolean locked = false;
    private String lockName;
    private boolean hasBeenBound;

    public LockableBlockEntity(BlockPos pos, BlockState state, String lockName) {
        super((BlockEntityType)ModBlockEntities.CELL_DOOR_BLOCK_ENTITY.get(), pos, state);
        this.lockName = lockName;
        this.hasBeenBound = false;
    }

    public LockableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CELL_DOOR_BLOCK_ENTITY.get(), pos, state);
        this.lockName = "info.cuffed.lock";
        this.hasBeenBound = false;
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("LockId", this.lockId);
        tag.m_128379_("Locked", this.locked);
        tag.m_128359_("LockName", this.lockName);
        tag.m_128379_("HasBeenBound", this.hasBeenBound);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.lockId = tag.m_128342_("LockId");
        this.locked = tag.m_128471_("Locked");
        this.lockName = tag.m_128461_("LockName");
        this.hasBeenBound = tag.m_128471_("HasBeenBound");
    }

    public void setLocked(boolean value, Level level, Player player, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11745_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        player.m_5661_((Component)Component.m_237115_((String)("info.lock.toggle_" + (!this.locked ? "on" : "off"))), true);
        this.locked = value;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public UUID getLockId() {
        return this.lockId;
    }

    public String getLockName() {
        return this.lockName;
    }

    public boolean hasBeenBound() {
        return this.hasBeenBound;
    }

    public void bind() {
        this.hasBeenBound = true;
    }

    public void resetBinding() {
        this.lockId = UUID.randomUUID();
        this.locked = false;
        this.hasBeenBound = false;
    }
}

