/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.cap;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.compat.BetterCombatCompat;
import com.lazrproductions.cuffed.compat.ElenaiDodge2Compat;
import com.lazrproductions.cuffed.compat.EpicFightCompat;
import com.lazrproductions.cuffed.compat.ParcoolCompat;
import com.lazrproductions.cuffed.compat.PlayerReviveCompat;
import com.lazrproductions.cuffed.effect.RestrainedEffectInstance;
import com.lazrproductions.cuffed.init.ModEffects;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModStatistics;
import com.lazrproductions.cuffed.items.base.AbstractRestraintKeyItem;
import com.lazrproductions.cuffed.restraints.RestraintAPI;
import com.lazrproductions.cuffed.restraints.base.AbstractArmRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractHeadRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractLegRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.base.IEnchantableRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.lazrproductions.lazrslib.common.math.MathUtilities;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;

public class RestrainableCapability
implements IRestrainableCapability {
    public AbstractArmRestraint armRestraint = null;
    public AbstractLegRestraint legRestraint = null;
    public AbstractHeadRestraint headRestraint = null;
    public ServerPlayer playerEscortingMe = null;
    public ServerPlayer whoImEscorting = null;
    public ServerPlayer playerFriskingMe = null;
    private boolean markedForSync = false;
    public int age = 0;

    @Override
    public void tickServer(ServerPlayer player) {
        if (this.headRestraint != null) {
            this.headRestraint.onTickServer(player);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onTickServer(player);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onTickServer(player);
        }
        int encoded = this.encodeRestraintDisabilities();
        if (this.isRestrained()) {
            if (!player.m_21023_((MobEffect)ModEffects.RESTRAINED_EFFECT.get())) {
                RestrainedEffectInstance inst = new RestrainedEffectInstance(-1, encoded);
                player.m_7292_((MobEffectInstance)inst);
            } else {
                RestrainedEffectInstance e;
                MobEffectInstance mobEffectInstance = player.m_21124_((MobEffect)ModEffects.RESTRAINED_EFFECT.get());
                if (mobEffectInstance instanceof RestrainedEffectInstance && (e = (RestrainedEffectInstance)mobEffectInstance).m_19564_() != encoded) {
                    player.m_21195_((MobEffect)ModEffects.RESTRAINED_EFFECT.get());
                    RestrainedEffectInstance inst = new RestrainedEffectInstance(-1, encoded);
                    player.m_7292_((MobEffectInstance)inst);
                }
            }
        } else if (player.m_21023_((MobEffect)ModEffects.RESTRAINED_EFFECT.get())) {
            player.m_21195_((MobEffect)ModEffects.RESTRAINED_EFFECT.get());
        }
        if (this.playerEscortingMe != null) {
            this.playerEscortingMe.m_240418_((Component)Component.m_237115_((String)"info.cuffed.escorting.giving").m_7220_(player.m_5446_()), true);
            player.m_240418_((Component)Component.m_237115_((String)"info.cuffed.escorting.getting").m_7220_(this.playerEscortingMe.m_5446_()), true);
            Vec3 escortPivot = MathUtilities.GetPositionFromTowardsRotationInDegrees((Vec3)this.playerEscortingMe.m_20182_(), (double)(this.playerEscortingMe.m_146908_() + 90.0f), (double)0.0, (double)0.45f);
            Vec3 escortTarget = MathUtilities.GetPositionFromTowardsRotationInDegrees((Vec3)escortPivot, (double)this.playerEscortingMe.m_146908_(), (double)0.0, (double)0.9f);
            player.f_8906_.m_9780_(escortTarget.m_7096_(), escortTarget.m_7098_(), escortTarget.m_7094_(), this.playerEscortingMe.m_146908_(), player.m_146909_(), RelativeMovement.f_263774_);
            if (!this.isRestrained()) {
                CuffedAPI.Capabilities.getRestrainableCapability((Player)this.playerEscortingMe).stopEscortingPlayer();
            } else if (this.playerEscortingMe == null || this.playerEscortingMe.m_213877_()) {
                this.playerEscortingMe = null;
            } else if (this.playerEscortingMe.m_20270_((Entity)player) > 3.5f || this.playerEscortingMe.m_6047_()) {
                this.playerEscortingMe.m_240418_((Component)Component.m_237115_((String)"info.cuffed.escorting.giving.cancel").m_7220_(player.m_5446_()), true);
                player.m_240418_((Component)Component.m_237110_((String)"info.cuffed.escorting.getting.cancel", (Object[])new Object[]{this.playerEscortingMe.m_5446_()}), true);
                CuffedAPI.Capabilities.getRestrainableCapability((Player)this.playerEscortingMe).stopEscortingPlayer();
            } else if (this.playerEscortingMe != null && this.playerEscortingMe.m_213877_() || player.m_213877_()) {
                CuffedAPI.Capabilities.getRestrainableCapability((Player)this.playerEscortingMe).stopEscortingPlayer();
            }
        }
        if (this.whoImEscorting == null || this.whoImEscorting.m_213877_()) {
            this.whoImEscorting = null;
        }
        if (this.markedForSync) {
            CuffedAPI.Networking.sendRestraintSyncPacket(player);
            this.markedForSync = false;
        }
        ++this.age;
    }

    @Override
    public void copyFrom(CompoundTag tag, ServerLevel level) {
        this.deserializeNBT(tag);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.headRestraint != null) {
            nbt.m_128365_("HeadRestraint", (Tag)this.headRestraint.serializeNBT());
        }
        if (this.armRestraint != null) {
            nbt.m_128365_("ArmRestraint", (Tag)this.armRestraint.serializeNBT());
        }
        if (this.legRestraint != null) {
            nbt.m_128365_("LegRestraint", (Tag)this.legRestraint.serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.headRestraint = nbt.m_128441_("HeadRestraint") ? (AbstractHeadRestraint)RestraintAPI.getRestraintFromTag(nbt.m_128469_("HeadRestraint")) : null;
        this.armRestraint = nbt.m_128441_("ArmRestraint") ? (AbstractArmRestraint)RestraintAPI.getRestraintFromTag(nbt.m_128469_("ArmRestraint")) : null;
        this.legRestraint = nbt.m_128441_("LegRestraint") ? (AbstractLegRestraint)RestraintAPI.getRestraintFromTag(nbt.m_128469_("LegRestraint")) : null;
        this.markedForSync = true;
    }

    @Override
    public boolean onInteractedByOther(ServerPlayer player, ServerPlayer other, double interactionHeight, ItemStack stack, InteractionHand hand, boolean avoidEscort) {
        if (RestraintAPI.isRestraintItem(stack)) {
            AbstractLegRestraint l;
            AbstractRestraint a;
            AbstractRestraint r;
            if (interactionHeight > 1.5 && (r = RestraintAPI.getRestraintFromStack(stack, RestraintType.Head, player, other)) instanceof AbstractHeadRestraint && this.TryEquipRestraint(player, other, (AbstractHeadRestraint)(a = (AbstractHeadRestraint)r))) {
                ModStatistics.awardRestraintItemUsed(other, stack);
                stack.m_41774_(1);
                return true;
            }
            if (interactionHeight > (double)0.33f && interactionHeight <= 1.5 && (r = RestraintAPI.getRestraintFromStack(stack, RestraintType.Arm, player, other)) instanceof AbstractArmRestraint && this.TryEquipRestraint(player, other, (AbstractArmRestraint)(a = (AbstractArmRestraint)r))) {
                ModStatistics.awardRestraintItemUsed(other, stack);
                stack.m_41774_(1);
                return true;
            }
            if (interactionHeight <= (double)0.33f && (r = RestraintAPI.getRestraintFromStack(stack, RestraintType.Leg, player, other)) instanceof AbstractLegRestraint && this.TryEquipRestraint(player, other, l = (AbstractLegRestraint)r)) {
                ModStatistics.awardRestraintItemUsed(other, stack);
                stack.m_41774_(1);
                return true;
            }
        } else if (stack.m_41720_() instanceof AbstractRestraintKeyItem) {
            if (interactionHeight > 1.5) {
                if (this.headRestraint != null && (this.headRestraint.getKeyItem() == null || this.headRestraint.getKeyItem() == stack.m_41720_()) && this.TryUnequipRestraint(player, other, RestraintType.Head)) {
                    other.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
                    return true;
                }
            } else if (interactionHeight > (double)0.33f && interactionHeight <= 1.5) {
                if (this.armRestraint != null && (this.armRestraint.getKeyItem() == null || this.armRestraint.getKeyItem() == stack.m_41720_()) && this.TryUnequipRestraint(player, other, RestraintType.Arm)) {
                    other.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
                    return true;
                }
            } else if (interactionHeight <= (double)0.33f && this.legRestraint != null && (this.legRestraint.getKeyItem() == null || this.legRestraint.getKeyItem() == stack.m_41720_()) && this.TryUnequipRestraint(player, other, RestraintType.Leg)) {
                other.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
                return true;
            }
        } else if (stack.m_150930_((Item)ModItems.LOCKPICK.get())) {
            int lockpickType = -1;
            if (interactionHeight > 1.5 && this.headRestrained() && this.headRestraint.getLockpickable()) {
                lockpickType = RestraintType.Head.toInteger();
            } else if (interactionHeight > (double)0.33f && interactionHeight <= 1.5 && this.armsRestrained() && this.armRestraint.getLockpickable()) {
                lockpickType = RestraintType.Arm.toInteger();
            } else if (interactionHeight <= (double)0.33f && this.legsRestrained() && this.legRestraint.getLockpickable()) {
                lockpickType = RestraintType.Leg.toInteger();
            }
            if (lockpickType > -1) {
                int speedIncreasePerPick;
                int n = lockpickType == RestraintType.Leg.toInteger() ? this.getLegRestraint().getLockpickingSpeedIncreasePerPick() : (speedIncreasePerPick = lockpickType == RestraintType.Arm.toInteger() ? this.getArmRestraint().getLockpickingSpeedIncreasePerPick() : this.getHeadRestraint().getLockpickingSpeedIncreasePerPick());
                int progressPerPick = lockpickType == RestraintType.Leg.toInteger() ? this.getLegRestraint().getLockpickingProgressPerPick() : (lockpickType == RestraintType.Arm.toInteger() ? this.getArmRestraint().getLockpickingProgressPerPick() : this.getHeadRestraint().getLockpickingProgressPerPick());
                CuffedAPI.Networking.sendLockpickBeginPickingRestraintPacketToClient(other, player.m_20148_().toString(), lockpickType, speedIncreasePerPick, progressPerPick);
                return true;
            }
        } else if (stack.m_41619_() && other.m_6047_()) {
            if (interactionHeight > 1.5) {
                if (this.headRestraint != null && this.headRestraint.getKeyItem() == null && this.TryUnequipRestraint(player, other, RestraintType.Head)) {
                    other.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
                    return true;
                }
            } else if (interactionHeight > (double)0.33f && interactionHeight <= 1.5) {
                if (this.armRestraint != null && this.armRestraint.getKeyItem() == null && this.TryUnequipRestraint(player, other, RestraintType.Arm)) {
                    other.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
                    return true;
                }
            } else if (interactionHeight <= (double)0.33f && this.legRestraint != null && this.legRestraint.getKeyItem() == null && this.TryUnequipRestraint(player, other, RestraintType.Leg)) {
                other.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
                return true;
            }
        } else if (stack.m_41619_() && !other.m_6047_() && this.isRestrained() && !avoidEscort) {
            CuffedAPI.Capabilities.getRestrainableCapability((Player)other).startEscortingPlayer(other, player);
            return true;
        }
        return false;
    }

    @Override
    public boolean restraintsDisabledBreakingBlocks() {
        boolean v = false;
        if (this.armRestraint != null && !this.armRestraint.AllowBreakingBlocks()) {
            v = true;
        }
        if (this.legRestraint != null && !this.legRestraint.AllowBreakingBlocks()) {
            v = true;
        }
        if (this.headRestraint != null && !this.headRestraint.AllowBreakingBlocks()) {
            v = true;
        }
        return v;
    }

    @Override
    public boolean restraintsDisabledItemUse() {
        boolean v = false;
        if (this.armRestraint != null && !this.armRestraint.AllowItemUse()) {
            v = true;
        }
        if (this.legRestraint != null && !this.legRestraint.AllowItemUse()) {
            v = true;
        }
        if (this.headRestraint != null && !this.headRestraint.AllowItemUse()) {
            v = true;
        }
        return v;
    }

    @Override
    public boolean restraintsDisabledMovement() {
        boolean v = false;
        if (this.armRestraint != null && !this.armRestraint.AllowMovement()) {
            v = true;
        }
        if (this.legRestraint != null && !this.legRestraint.AllowMovement()) {
            v = true;
        }
        if (this.headRestraint != null && !this.headRestraint.AllowMovement()) {
            v = true;
        }
        return v;
    }

    @Override
    public boolean restraintsDisabledJumping() {
        boolean v = false;
        if (this.armRestraint != null && !this.armRestraint.AllowJumping()) {
            v = true;
        }
        if (this.legRestraint != null && !this.legRestraint.AllowJumping()) {
            v = true;
        }
        if (this.headRestraint != null && !this.headRestraint.AllowJumping()) {
            v = true;
        }
        return v;
    }

    @Override
    public int encodeRestraintDisabilities() {
        boolean noMining = false;
        boolean noItemUse = false;
        boolean noMovement = false;
        boolean noJumping = false;
        if (this.armRestraint != null) {
            if (!this.armRestraint.AllowBreakingBlocks()) {
                noMining = true;
            }
            if (!this.armRestraint.AllowItemUse()) {
                noItemUse = true;
            }
            if (!this.armRestraint.AllowMovement()) {
                noMovement = true;
            }
            if (!this.armRestraint.AllowJumping()) {
                noJumping = true;
            }
        }
        if (this.legRestraint != null) {
            if (!this.legRestraint.AllowBreakingBlocks()) {
                noMining = true;
            }
            if (!this.legRestraint.AllowItemUse()) {
                noItemUse = true;
            }
            if (!this.legRestraint.AllowMovement()) {
                noMovement = true;
            }
            if (!this.legRestraint.AllowJumping()) {
                noJumping = true;
            }
        }
        if (this.headRestraint != null) {
            if (!this.headRestraint.AllowBreakingBlocks()) {
                noMining = true;
            }
            if (!this.headRestraint.AllowItemUse()) {
                noItemUse = true;
            }
            if (!this.headRestraint.AllowMovement()) {
                noMovement = true;
            }
            if (!this.headRestraint.AllowJumping()) {
                noJumping = true;
            }
        }
        return RestrainedEffectInstance.encodeRestraintProperties(noMining, noItemUse, noMovement, noJumping);
    }

    @Override
    public boolean armsRestrained() {
        return this.armRestraint != null;
    }

    @Override
    public boolean legsRestrained() {
        return this.legRestraint != null;
    }

    @Override
    public boolean headRestrained() {
        return this.headRestraint != null;
    }

    @Override
    public boolean isRestrained() {
        return this.armsRestrained() || this.legsRestrained() || this.headRestrained();
    }

    @Override
    public boolean isRestrained(RestraintType type) {
        if (type == RestraintType.Arm) {
            return this.armsRestrained();
        }
        if (type == RestraintType.Leg) {
            return this.legsRestrained();
        }
        return this.headRestrained();
    }

    @Override
    public ResourceLocation getArmRestraintId() {
        if (this.armRestraint != null) {
            return this.armRestraint.getId();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air");
    }

    @Override
    public ResourceLocation getLegRestraintId() {
        if (this.legRestraint != null) {
            return this.legRestraint.getId();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air");
    }

    @Override
    public ResourceLocation getHeadRestraintId() {
        if (this.headRestraint != null) {
            return this.headRestraint.getId();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air");
    }

    @Override
    public ResourceLocation getRestraintId(RestraintType type) {
        if (type == RestraintType.Arm) {
            return this.getArmRestraintId();
        }
        if (type == RestraintType.Head) {
            return this.getHeadRestraintId();
        }
        return this.getLegRestraintId();
    }

    @Override
    public AbstractArmRestraint getArmRestraint() {
        return this.armRestraint;
    }

    @Override
    public AbstractLegRestraint getLegRestraint() {
        return this.legRestraint;
    }

    @Override
    public AbstractHeadRestraint getHeadRestraint() {
        return this.headRestraint;
    }

    @Override
    public AbstractRestraint getRestraint(RestraintType type) {
        if (type == RestraintType.Arm) {
            return this.getArmRestraint();
        }
        if (type == RestraintType.Head) {
            return this.getHeadRestraint();
        }
        return this.getLegRestraint();
    }

    @Override
    public void setArmRestraintWithoutWarning(@Nonnull ServerPlayer player, @Nullable AbstractArmRestraint newRestraint) {
        this.armRestraint = newRestraint;
        CuffedAPI.Networking.sendRestraintSyncPacket(player);
    }

    @Override
    public void setLegRestraintWithoutWarning(@Nonnull ServerPlayer player, @Nullable AbstractLegRestraint newRestraint) {
        this.legRestraint = newRestraint;
        CuffedAPI.Networking.sendRestraintSyncPacket(player);
    }

    @Override
    public void setHeadRestraintWithoutWarning(@Nonnull ServerPlayer player, @Nullable AbstractHeadRestraint newRestraint) {
        this.headRestraint = newRestraint;
        CuffedAPI.Networking.sendRestraintSyncPacket(player);
    }

    @Override
    public void setRestraintWithoutWarning(@Nonnull ServerPlayer player, @Nonnull AbstractRestraint newValue, RestraintType type) {
        if (type == RestraintType.Arm) {
            if (newValue instanceof AbstractArmRestraint) {
                AbstractArmRestraint arm;
                this.armRestraint = arm = (AbstractArmRestraint)newValue;
            }
        } else if (type == RestraintType.Head) {
            if (newValue instanceof AbstractHeadRestraint) {
                AbstractHeadRestraint head;
                this.headRestraint = head = (AbstractHeadRestraint)newValue;
            }
        } else if (type == RestraintType.Leg && newValue instanceof AbstractLegRestraint) {
            AbstractLegRestraint leg;
            this.legRestraint = leg = (AbstractLegRestraint)newValue;
        }
        CuffedAPI.Networking.sendRestraintSyncPacket(player);
    }

    public boolean TryEquipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer captor, AbstractArmRestraint restraint) {
        if (this.armRestraint == null) {
            if (((Boolean)CuffedMod.SERVER_CONFIG.REQUIRE_LOW_HEALTH_TO_RESTRAIN.get()).booleanValue() && !this.isRestrained()) {
                if (!CuffedMod.PlayerReviveInstalled) {
                    if (player.m_21223_() / player.m_21233_() <= 0.3f) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2));
                        this.EquipRestraint(player, captor, restraint);
                        return true;
                    }
                } else if (PlayerReviveCompat.IsBleedingOut((Player)player)) {
                    PlayerReviveCompat.Revive((Player)player);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2));
                    this.EquipRestraint(player, captor, restraint);
                    return true;
                }
            } else {
                this.EquipRestraint(player, captor, restraint);
                return true;
            }
        }
        return false;
    }

    public boolean TryEquipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer captor, AbstractLegRestraint restraint) {
        if (this.legRestraint == null) {
            if (((Boolean)CuffedMod.SERVER_CONFIG.REQUIRE_LOW_HEALTH_TO_RESTRAIN.get()).booleanValue() && !this.isRestrained()) {
                if (!CuffedMod.PlayerReviveInstalled) {
                    if (player.m_21223_() / player.m_21233_() <= 0.3f) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2));
                        this.EquipRestraint(player, captor, restraint);
                        return true;
                    }
                } else if (PlayerReviveCompat.IsBleedingOut((Player)player)) {
                    PlayerReviveCompat.Revive((Player)player);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2));
                    this.EquipRestraint(player, captor, restraint);
                    return true;
                }
            } else {
                this.EquipRestraint(player, captor, restraint);
                return true;
            }
        }
        return false;
    }

    public boolean TryEquipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer captor, AbstractHeadRestraint restraint) {
        if (this.headRestraint == null) {
            if (((Boolean)CuffedMod.SERVER_CONFIG.REQUIRE_LOW_HEALTH_TO_RESTRAIN.get()).booleanValue() && !this.isRestrained()) {
                if (!CuffedMod.PlayerReviveInstalled) {
                    if (player.m_21223_() / player.m_21233_() <= 0.3f) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2));
                        this.EquipRestraint(player, captor, restraint);
                        return true;
                    }
                } else if (PlayerReviveCompat.IsBleedingOut((Player)player)) {
                    PlayerReviveCompat.Revive((Player)player);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 2));
                    this.EquipRestraint(player, captor, restraint);
                    return true;
                }
            } else {
                this.EquipRestraint(player, captor, restraint);
                return true;
            }
        }
        return false;
    }

    public void EquipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer captor, AbstractArmRestraint restraint) {
        AbstractLegRestraint oldRestraint = this.legRestraint;
        this.armRestraint = restraint;
        this.armRestraint.onEquippedServer(player, captor);
        CuffedAPI.Networking.sendRestraintEquipPacket(player, captor, RestraintType.Arm, this.armRestraint, oldRestraint);
    }

    public void EquipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer captor, AbstractLegRestraint restraint) {
        AbstractLegRestraint oldRestraint = this.legRestraint;
        this.legRestraint = restraint;
        this.legRestraint.onEquippedServer(player, captor);
        CuffedAPI.Networking.sendRestraintEquipPacket(player, captor, RestraintType.Leg, this.legRestraint, oldRestraint);
    }

    public void EquipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer captor, AbstractHeadRestraint restraint) {
        AbstractHeadRestraint oldRestraint = this.headRestraint;
        this.headRestraint = restraint;
        this.headRestraint.onEquippedServer(player, captor);
        CuffedAPI.Networking.sendRestraintEquipPacket(player, captor, RestraintType.Head, this.headRestraint, oldRestraint);
    }

    public boolean TryUnequipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer releaser, RestraintType type) {
        if (type == RestraintType.Arm && this.armRestraint != null || type == RestraintType.Leg && this.legRestraint != null || type == RestraintType.Head && this.headRestraint != null) {
            this.UnequipRestraint(player, releaser, type);
            return true;
        }
        return false;
    }

    public void UnequipRestraint(@Nonnull ServerPlayer player, @Nullable ServerPlayer releaser, RestraintType type) {
        AbstractRestraint oldRestraint = null;
        if (type == RestraintType.Arm) {
            oldRestraint = this.armRestraint;
        } else if (type == RestraintType.Leg) {
            oldRestraint = this.legRestraint;
        } else if (type == RestraintType.Head) {
            oldRestraint = this.headRestraint;
        }
        if (oldRestraint != null) {
            ItemStack stack = oldRestraint.saveToItemStack();
            if (releaser == null || !releaser.m_36356_(stack)) {
                ItemEntity e = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.6, player.m_20189_(), stack);
                e.m_32060_();
                player.m_9236_().m_7967_((Entity)e);
            }
            oldRestraint.onUnequippedServer(player);
        }
        if (type == RestraintType.Arm) {
            this.armRestraint = null;
        } else if (type == RestraintType.Leg) {
            this.legRestraint = null;
        } else if (type == RestraintType.Head) {
            this.headRestraint = null;
        }
        CuffedAPI.Networking.sendRestraintEquipPacket(player, releaser, type, null, oldRestraint);
    }

    public void beginSkillcheck() {
    }

    @Override
    public void startEscortingPlayer(@Nonnull ServerPlayer self, @Nonnull ServerPlayer playerToEscort) {
        playerToEscort.m_6038_();
        CuffedAPI.Capabilities.getRestrainableCapability((Player)playerToEscort).startGettingEscortedByPlayer(self);
        this.whoImEscorting = playerToEscort;
    }

    @Override
    public void startGettingEscortedByPlayer(@Nonnull ServerPlayer other) {
        this.playerEscortingMe = other;
    }

    @Override
    public void stopEscortingPlayer() {
        CuffedAPI.Capabilities.getRestrainableCapability((Player)this.whoImEscorting).stopGettingEscortedByPlayer();
        this.whoImEscorting = null;
    }

    @Override
    public void stopGettingEscortedByPlayer() {
        this.playerEscortingMe = null;
    }

    @Override
    public ServerPlayer getWhoImEscorting() {
        return this.whoImEscorting;
    }

    @Override
    public ServerPlayer getMyEscort() {
        return this.playerEscortingMe;
    }

    @Override
    public void tickClient(Player player) {
        if (this.isRestrained()) {
            if (CuffedMod.BetterCombatInstalled) {
                BetterCombatCompat.Disable();
            }
            if (CuffedMod.EpicFightInstalled) {
                EpicFightCompat.Disable(player);
            }
            if (CuffedMod.ParcoolInstalled) {
                ParcoolCompat.Disable();
            }
            if (CuffedMod.ElenaiDodge2Installed) {
                ElenaiDodge2Compat.Disable();
            }
        } else {
            if (CuffedMod.BetterCombatInstalled) {
                BetterCombatCompat.Reset();
            }
            if (CuffedMod.EpicFightInstalled) {
                EpicFightCompat.Reset(player);
            }
            if (CuffedMod.ParcoolInstalled) {
                ParcoolCompat.Reset();
            }
            if (CuffedMod.ElenaiDodge2Installed) {
                ElenaiDodge2Compat.Reset();
            }
        }
        if (this.headRestraint != null) {
            this.headRestraint.onTickClient(player);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onTickClient(player);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onTickClient(player);
        }
    }

    @Override
    public void onKeyInput(Player player, int keyCode, int action) {
        if (this.headRestraint != null) {
            this.headRestraint.onKeyInput(player, keyCode, action);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onKeyInput(player, keyCode, action);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onKeyInput(player, keyCode, action);
        }
    }

    @Override
    public void onMouseInput(Player player, int keyCode, int action) {
        if (this.headRestraint != null) {
            this.headRestraint.onMouseInput(player, keyCode, action);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onMouseInput(player, keyCode, action);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onMouseInput(player, keyCode, action);
        }
    }

    @Override
    public void renderOverlay(Player player, GuiGraphics graphics, float partialTick, Window window) {
        if (this.headRestraint != null) {
            this.headRestraint.renderOverlay(player, graphics, partialTick, window);
        }
        if (this.armRestraint != null) {
            this.armRestraint.renderOverlay(player, graphics, partialTick, window);
        }
        if (this.legRestraint != null) {
            this.legRestraint.renderOverlay(player, graphics, partialTick, window);
        }
    }

    public ArrayList<Integer> gatherBlockedInputs() {
        ArrayList<Integer> b = new ArrayList<Integer>();
        if (this.headRestraint != null) {
            b.addAll(this.headRestraint.getBlockedKeyCodes());
        }
        if (this.armRestraint != null) {
            b.addAll(this.armRestraint.getBlockedKeyCodes());
        }
        if (this.legRestraint != null) {
            b.addAll(this.legRestraint.getBlockedKeyCodes());
        }
        return b;
    }

    @Override
    public void onLoginServer(ServerPlayer player) {
        if (player.m_21023_((MobEffect)ModEffects.RESTRAINED_EFFECT.get())) {
            player.m_21195_((MobEffect)ModEffects.RESTRAINED_EFFECT.get());
        }
    }

    @Override
    public void onLoginClient(Player player) {
    }

    @Override
    public void onLogoutServer(ServerPlayer player) {
    }

    @Override
    public void onLogoutClient(Player player) {
    }

    @Override
    public void onDeathServer(ServerPlayer player) {
        IEnchantableRestraint e;
        AbstractRestraint abstractRestraint;
        boolean shouldUnequip;
        if (this.headRestraint != null) {
            this.headRestraint.onDeathServer(player);
            shouldUnequip = true;
            abstractRestraint = this.headRestraint;
            if (abstractRestraint instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)((Object)abstractRestraint)).hasEnchantment(Enchantments.f_44975_)) {
                shouldUnequip = false;
            }
            if (shouldUnequip) {
                this.TryUnequipRestraint(player, null, RestraintType.Head);
            }
        }
        if (this.armRestraint != null) {
            this.armRestraint.onDeathServer(player);
            shouldUnequip = true;
            abstractRestraint = this.armRestraint;
            if (abstractRestraint instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)((Object)abstractRestraint)).hasEnchantment(Enchantments.f_44975_)) {
                shouldUnequip = false;
            }
            if (shouldUnequip) {
                this.TryUnequipRestraint(player, null, RestraintType.Arm);
            }
        }
        if (this.legRestraint != null) {
            this.legRestraint.onDeathServer(player);
            shouldUnequip = true;
            abstractRestraint = this.legRestraint;
            if (abstractRestraint instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)((Object)abstractRestraint)).hasEnchantment(Enchantments.f_44975_)) {
                shouldUnequip = false;
            }
            if (shouldUnequip) {
                this.TryUnequipRestraint(player, null, RestraintType.Leg);
            }
        }
    }

    @Override
    public void onDeathClient(Player player) {
        if (this.headRestraint != null) {
            this.headRestraint.onDeathClient(player);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onDeathClient(player);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onDeathClient(player);
        }
    }

    @Override
    public float onLandServer(ServerPlayer player, float distance, float damageMultiplier) {
        float mult = damageMultiplier;
        if (this.headRestraint != null) {
            mult *= this.headRestraint.onLandServer(player, distance, damageMultiplier);
        }
        if (this.armRestraint != null) {
            mult *= this.armRestraint.onLandServer(player, distance, damageMultiplier);
        }
        if (this.legRestraint != null) {
            mult *= this.legRestraint.onLandServer(player, distance, damageMultiplier);
        }
        return mult;
    }

    @Override
    public void onLandClient(Player player, float distance, float damageMultiplier) {
        if (this.headRestraint != null) {
            this.headRestraint.onLandClient(player, distance, damageMultiplier);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onLandClient(player, distance, damageMultiplier);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onLandClient(player, distance, damageMultiplier);
        }
    }

    @Override
    public void onJumpServer(ServerPlayer player) {
        if (this.headRestraint != null) {
            this.headRestraint.onJumpServer(player);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onJumpServer(player);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onJumpServer(player);
        }
    }

    @Override
    public void onJumpClient(Player player) {
        if (this.headRestraint != null) {
            this.headRestraint.onJumpClient(player);
        }
        if (this.armRestraint != null) {
            this.armRestraint.onJumpClient(player);
        }
        if (this.legRestraint != null) {
            this.legRestraint.onJumpClient(player);
        }
    }

    @Override
    public boolean onTickRideServer(ServerPlayer player, Entity vehicle) {
        vehicle.m_20256_(Vec3.f_82478_);
        return true;
    }

    @Override
    public boolean onTickRideClient(Player player, Entity vehicle) {
        vehicle.m_20256_(Vec3.f_82478_);
        return true;
    }
}

