/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.entity;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.init.ModEntityTypes;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModTags;
import com.lazrproductions.cuffed.items.KeyItem;
import com.lazrproductions.cuffed.items.KeyRingItem;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class PadlockEntity
extends HangingEntity {
    private static final EntityDataAccessor<Boolean> DATA_LOCKED = SynchedEntityData.m_135353_(PadlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_REINFORCED = SynchedEntityData.m_135353_(PadlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_ITEM_USED_TO_REINFORCE = SynchedEntityData.m_135353_(PadlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_LOCK_ID = SynchedEntityData.m_135353_(PadlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_BEEN_BOUND = SynchedEntityData.m_135353_(PadlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PadlockEntity(EntityType<? extends HangingEntity> type, Level level) {
        super(type, level);
    }

    public PadlockEntity(Level world, BlockPos pos) {
        super((EntityType)ModEntityTypes.PADLOCK.get(), world, pos);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        this.f_19804_.m_135381_(DATA_LOCK_ID, Optional.of(UUID.randomUUID()));
    }

    public boolean isOnSuitableBlock() {
        return this.m_9236_().m_8055_(this.f_31698_).m_204336_(ModTags.Blocks.LOCKABLE_BLOCKS);
    }

    public void m_5553_(@Nullable Entity entity) {
        float xO;
        this.m_5496_(SoundEvents.f_11794_, 1.0f, 1.0f);
        float f = this.m_146908_() == 90.0f ? -1.0f : (xO = this.m_146908_() == 270.0f || this.m_146908_() == -90.0f ? 1.0f : 0.0f);
        float zO = this.m_146908_() == 0.0f ? 1.0f : (this.m_146908_() == 180.0f || this.m_146908_() == -180.0f ? -1.0f : 0.0f);
        ItemEntity itementity = new ItemEntity(this.m_9236_(), (double)((float)this.f_31698_.m_123341_() + 0.5f + xO), (double)((float)this.f_31698_.m_123342_() + 0.5f), (double)((float)this.f_31698_.m_123343_() + 0.5f + zO), new ItemStack((ItemLike)ModItems.PADLOCK.get()));
        itementity.m_32060_();
        this.m_9236_().m_7967_((Entity)itementity);
        if (this.isReinforced()) {
            String i = this.getItemUsedToReinforce();
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)i)));
            ItemEntity e = new ItemEntity(this.m_9236_(), (double)((float)this.f_31698_.m_123341_() + 0.5f + xO), (double)((float)this.f_31698_.m_123342_() + 0.5f), (double)((float)this.f_31698_.m_123343_() + 0.5f + zO), stack);
            e.m_32060_();
            this.m_9236_().m_7967_((Entity)e);
        }
    }

    public InteractionResult m_6096_(@Nonnull Player interactor, @Nonnull InteractionHand hand) {
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = interactor.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.CREATIVE_RESTRAINT_CUTTER.get())) {
            interactor.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.CREATIVE_KEY.get())));
            if (!interactor.m_6047_()) {
                this.setLocked(!this.isLocked());
                if (this.isLocked()) {
                    interactor.m_5661_((Component)Component.m_237113_((String)"Padlock locked."), true);
                } else {
                    interactor.m_5661_((Component)Component.m_237113_((String)"Padlock unlocked."), true);
                }
                this.m_5496_(SoundEvents.f_12012_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            KeyItem.removeBoundLock(stack);
            this.RemoveLock();
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)ModItems.KEY.get())) {
            if (KeyItem.isBoundToLock(stack, this.getLockId())) {
                interactor.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY.get())));
                if (!interactor.m_6047_()) {
                    this.setLocked(!this.isLocked());
                    if (this.isLocked()) {
                        interactor.m_5661_((Component)Component.m_237113_((String)"Padlock locked."), true);
                    } else {
                        interactor.m_5661_((Component)Component.m_237113_((String)"Padlock unlocked."), true);
                    }
                    this.m_5496_(SoundEvents.f_12012_, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                KeyItem.removeBoundLock(stack);
                this.RemoveLock();
                return InteractionResult.SUCCESS;
            }
            if (!this.getHasBeenBound() && KeyItem.tryToSetBoundId(interactor, stack, this.getLockId(), "Padlock")) {
                this.bind();
                return InteractionResult.SUCCESS;
            }
        }
        if (stack.m_150930_((Item)ModItems.KEY_RING.get())) {
            if (KeyRingItem.hasBoundId(stack, this.getLockId())) {
                interactor.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY_RING.get())));
                if (!interactor.m_6047_()) {
                    this.setLocked(!this.isLocked());
                    if (this.isLocked()) {
                        interactor.m_5661_((Component)Component.m_237113_((String)"Padlock locked."), true);
                    } else {
                        interactor.m_5661_((Component)Component.m_237113_((String)"Padlock unlocked."), true);
                    }
                    this.m_5496_(SoundEvents.f_12012_, 1.0f, 1.0f);
                    return InteractionResult.CONSUME;
                }
                KeyRingItem.removeBoundId(stack, this.getLockId());
                this.RemoveLock();
                return InteractionResult.CONSUME;
            }
            if (KeyRingItem.canBindLock(stack) && !this.getHasBeenBound() && KeyRingItem.tryToAddBoundId(interactor, stack, this.getLockId(), "entity.cuffed.padlock")) {
                this.bind();
                return InteractionResult.CONSUME;
            }
        }
        if (stack.m_204117_(ModTags.Items.CAN_REINFORCE_PADLOCK) && !this.isReinforced()) {
            interactor.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            this.setReinforced(true);
            this.setItemUsedToReinforce(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            stack.m_41774_(1);
            this.m_5496_(SoundEvents.f_12200_, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        if (stack.m_150930_((Item)ModItems.LOCKPICK.get())) {
            CuffedAPI.Networking.sendLockpickBeginPickingLockPacketToClient((ServerPlayer)interactor, this.m_19879_(), this.isReinforced() ? (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_SPEED_INCREASE_PER_PICK_FOR_BREAKING_REINFORCED_PADLOCKS.get() : (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_SPEED_INCREASE_PER_PICK_FOR_BREAKING_PADLOCKS.get(), this.isReinforced() ? (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_PROGRESS_PER_PICK_FOR_BREAKING_REINFORCED_PADLOCKS.get() : (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_PROGRESS_PER_PICK_FOR_BREAKING_PADLOCKS.get());
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)ModItems.CREATIVE_BIND_BREAKER.get()) && this.getHasBeenBound()) {
            this.resetBindings();
            interactor.m_213846_((Component)Component.m_237110_((String)"item.cuffed.creative_bind_breaker.use", (Object[])new Object[]{this.m_5446_().getString()}));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static PadlockEntity getOrCreateLockAt(Level level, BlockPos pos, Direction direction) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        for (PadlockEntity padlockentity : level.m_45976_(PadlockEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!padlockentity.m_31748_().equals((Object)pos)) continue;
            return padlockentity;
        }
        PadlockEntity padlockentity1 = new PadlockEntity(level, pos);
        padlockentity1.m_19915_(direction.m_122435_(), 0.0f);
        level.m_7967_((Entity)padlockentity1);
        return padlockentity1;
    }

    public static PadlockEntity getLockAt(Level level, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        for (PadlockEntity padlockentity : level.m_45976_(PadlockEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!padlockentity.m_31748_().equals((Object)pos)) continue;
            return padlockentity;
        }
        return null;
    }

    public void RemoveLock() {
        float xO;
        float f = this.m_146908_() == 90.0f ? -1.0f : (xO = this.m_146908_() == 270.0f || this.m_146908_() == -90.0f ? 1.0f : 0.0f);
        float zO = this.m_146908_() == 0.0f ? 1.0f : (this.m_146908_() == 180.0f || this.m_146908_() == -180.0f ? -1.0f : 0.0f);
        ItemEntity itementity = new ItemEntity(this.m_9236_(), (double)((float)this.f_31698_.m_123341_() + 0.5f + xO), (double)((float)this.f_31698_.m_123342_() + 0.5f), (double)((float)this.f_31698_.m_123343_() + 0.5f + zO), new ItemStack((ItemLike)ModItems.PADLOCK.get()));
        itementity.m_32060_();
        this.m_9236_().m_7967_((Entity)itementity);
        if (this.isReinforced()) {
            String i = this.getItemUsedToReinforce();
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.bySeparator((String)i, (char)':')));
            ItemEntity e = new ItemEntity(this.m_9236_(), (double)((float)this.f_31698_.m_123341_() + 0.5f + xO), (double)((float)this.f_31698_.m_123342_() + 0.5f), (double)((float)this.f_31698_.m_123343_() + 0.5f + zO), stack);
            e.m_32060_();
            this.m_9236_().m_7967_((Entity)e);
        }
        this.m_5496_(SoundEvents.f_11794_, 1.0f, 1.0f);
        this.m_146870_();
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_((double)Mth.m_14107_((double)x) + 0.5, (double)Mth.m_14107_((double)y) + 0.5, (double)Mth.m_14107_((double)z) + 0.5);
    }

    public int m_7076_() {
        return 16;
    }

    public int m_7068_() {
        return 16;
    }

    protected float m_6380_(@Nonnull Pose p_31839_, @Nonnull EntityDimensions p_31840_) {
        return 0.0625f;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LOCKED, (Object)false);
        this.f_19804_.m_135372_(DATA_REINFORCED, (Object)false);
        this.f_19804_.m_135372_(DATA_ITEM_USED_TO_REINFORCE, (Object)"empty");
        this.f_19804_.m_135372_(DATA_LOCK_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_HAS_BEEN_BOUND, (Object)false);
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Locked", this.isLocked());
        tag.m_128379_("Reinforced", this.isReinforced());
        tag.m_128362_("LockId", this.getLockId());
        tag.m_128379_("HasBeenBound", this.getHasBeenBound());
        tag.m_128359_("ItemUsedToReinforce", this.getItemUsedToReinforce());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_LOCKED, (Object)tag.m_128471_("Locked"));
        this.setLocked(tag.m_128471_("Locked"));
        this.f_19804_.m_135381_(DATA_REINFORCED, (Object)tag.m_128471_("Reinforced"));
        this.setReinforced(tag.m_128471_("Reinforced"));
        this.setItemUsedToReinforce(tag.m_128461_("ItemUsedToReinforce"));
        this.f_19804_.m_135381_(DATA_LOCK_ID, Optional.of(tag.m_128342_("LockId")));
        this.f_19804_.m_135381_(DATA_HAS_BEEN_BOUND, (Object)tag.m_128471_("HasBeenBound"));
    }

    public boolean m_7088_() {
        return !this.m_9236_().m_8055_(this.f_31698_).m_60795_();
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12200_, 1.0f, 1.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, 0, this.m_31748_());
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.PADLOCK.get());
    }

    public void setLocked(boolean value) {
        this.f_19804_.m_135381_(DATA_LOCKED, (Object)value);
    }

    public void setReinforced(boolean value) {
        this.f_19804_.m_135381_(DATA_REINFORCED, (Object)value);
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LOCKED);
    }

    public boolean isReinforced() {
        return (Boolean)this.f_19804_.m_135370_(DATA_REINFORCED);
    }

    public String getItemUsedToReinforce() {
        return (String)this.f_19804_.m_135370_(DATA_ITEM_USED_TO_REINFORCE);
    }

    public void setItemUsedToReinforce(String value) {
        this.f_19804_.m_135381_(DATA_ITEM_USED_TO_REINFORCE, (Object)value);
    }

    public UUID getLockId() {
        return (UUID)((Optional)this.f_19804_.m_135370_(DATA_LOCK_ID)).get();
    }

    public boolean getHasBeenBound() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_BEEN_BOUND);
    }

    public void bind() {
        this.f_19804_.m_135381_(DATA_HAS_BEEN_BOUND, (Object)true);
    }

    public void resetBindings() {
        this.setLocked(false);
        this.f_19804_.m_135381_(DATA_HAS_BEEN_BOUND, (Object)false);
        this.f_19804_.m_135381_(DATA_LOCK_ID, Optional.of(UUID.randomUUID()));
    }

    protected void m_7087_() {
        this.m_20343_((double)this.f_31698_.m_123341_() + 0.5, (double)this.f_31698_.m_123342_() + 0.3, (double)this.f_31698_.m_123343_() + 0.5);
        this.m_20011_(new AABB(this.m_20185_() - 0.52, this.m_20186_() - 0.12, this.m_20189_() - 0.52, this.m_20185_() + 0.52, this.m_20186_() + 0.13, this.m_20189_() + 0.52));
    }
}

