/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.entity.renderer;

import com.lazrproductions.cuffed.entity.WeightedAnchorEntity;
import com.lazrproductions.cuffed.entity.model.WeightedAnchorModel;
import com.lazrproductions.cuffed.init.ModModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WeightedAnchorEntityRenderer
extends EntityRenderer<WeightedAnchorEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cuffed", (String)"textures/entity/weighted_anchor.png");
    private final WeightedAnchorModel<WeightedAnchorEntity> model;
    public static PoseStack POSESTACK;
    public static MultiBufferSource BUFFER;

    public WeightedAnchorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WeightedAnchorModel(context.m_174023_(ModModelLayers.WEIGHTED_ANCHOR_LAYER));
    }

    protected void setupRotations(WeightedAnchorEntity entity, PoseStack stack, float rotX, float rotY, float rotZ) {
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotY));
    }

    public void render(@Nonnull WeightedAnchorEntity entity, float yaw, float partialTicks, @Nonnull PoseStack stack, @Nonnull MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)entity, yaw, partialTicks, stack, buffer, light);
        this.setupRotations(entity, stack, 0.0f, entity.m_146908_(), 0.0f);
        POSESTACK = stack;
        BUFFER = buffer;
        stack.m_85836_();
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(this.model.m_103119_(TEXTURE_LOCATION));
        this.model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entity.getIsEnchanted()) {
            this.renderGlint(stack, buffer, light, (Model)this.model);
        }
        stack.m_85849_();
    }

    private void renderGlint(PoseStack stack, MultiBufferSource buffer, int partialTick, Model model) {
        model.m_7695_(stack, buffer.m_6299_(RenderType.m_110499_()), partialTick, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getTextureLocation(@Nonnull WeightedAnchorEntity entity) {
        return TEXTURE_LOCATION;
    }
}

