/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.items;

import com.lazrproductions.cuffed.blocks.CellDoor;
import com.lazrproductions.cuffed.blocks.entity.LockableBlockEntity;
import com.lazrproductions.cuffed.blocks.entity.SafeBlockEntity;
import com.lazrproductions.cuffed.init.ModItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyItem
extends Item {
    public static final String TAG_ID = "Id";

    public KeyItem(Item.Properties p) {
        super(p);
    }

    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        if (!level.f_46443_ && context.m_43724_() == InteractionHand.MAIN_HAND) {
            Player player = context.m_43723_();
            BlockState state = level.m_8055_(context.m_8083_());
            if (player != null) {
                ItemStack stack = player.m_21120_(context.m_43724_());
                if (state.m_60734_() instanceof CellDoor) {
                    BlockEntity blockEntity;
                    BlockPos bottomPos = context.m_8083_();
                    if (state.m_61143_((Property)CellDoor.f_52730_) == DoubleBlockHalf.UPPER) {
                        bottomPos = bottomPos.m_7495_();
                        state = level.m_8055_(bottomPos);
                    }
                    if ((blockEntity = level.m_7702_(bottomPos)) instanceof LockableBlockEntity) {
                        LockableBlockEntity lockable = (LockableBlockEntity)blockEntity;
                        if (!KeyItem.isBoundToALock(stack) && !lockable.hasBeenBound()) {
                            if (KeyItem.tryToSetBoundId(player, stack, lockable.getLockId(), "Cell Door")) {
                                lockable.bind();
                                player.m_6278_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY.get())), 1);
                                return InteractionResult.SUCCESS;
                            }
                            return InteractionResult.FAIL;
                        }
                    }
                } else {
                    BlockEntity blockEntity = level.m_7702_(context.m_8083_());
                    if (blockEntity instanceof LockableBlockEntity) {
                        LockableBlockEntity lockable = (LockableBlockEntity)blockEntity;
                        if (!KeyItem.isBoundToALock(stack) && !lockable.hasBeenBound()) {
                            if (KeyItem.tryToSetBoundId(player, stack, lockable.getLockId(), lockable.getLockName())) {
                                lockable.bind();
                                player.m_6278_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY.get())), 1);
                                return InteractionResult.SUCCESS;
                            }
                            return InteractionResult.FAIL;
                        }
                    } else {
                        blockEntity = level.m_7702_(context.m_8083_());
                        if (blockEntity instanceof SafeBlockEntity) {
                            SafeBlockEntity safe = (SafeBlockEntity)blockEntity;
                            if (!KeyItem.isBoundToALock(stack) && !safe.hasBeenBound()) {
                                if (KeyItem.tryToSetBoundId(player, stack, safe.getLockId(), "block.cuffed.safe")) {
                                    safe.bind();
                                    player.m_6278_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY.get())), 1);
                                    return InteractionResult.SUCCESS;
                                }
                                return InteractionResult.FAIL;
                            }
                        }
                    }
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public static boolean tryToSetBoundId(Player player, ItemStack stack, UUID id, String lockName) {
        if (!stack.m_41784_().m_128441_(TAG_ID)) {
            KeyItem.setBoundId(stack, id);
            if (!player.m_9236_().m_46469_().m_46207_(GameRules.f_46145_)) {
                player.m_5661_((Component)Component.m_237115_((String)"item.cuffed.key.info.bound").m_7220_((Component)Component.m_237113_((String)("" + id))), false);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.cuffed.key.info.bound").m_7220_((Component)Component.m_237115_((String)lockName)), false);
            }
            player.m_5496_(SoundEvents.f_11743_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static void setBoundId(ItemStack stack, UUID id) {
        stack.m_41784_().m_128362_(TAG_ID, id);
    }

    public static void removeBoundLock(ItemStack stack) {
        if (stack.m_41784_().m_128441_(TAG_ID)) {
            stack.m_41749_(TAG_ID);
        }
    }

    @Nullable
    public static UUID getBoundLock(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ID)) {
            return null;
        }
        return tag.m_128342_(TAG_ID);
    }

    public static boolean isBoundToLock(@Nonnull ItemStack stack, @Nonnull UUID id) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ID)) {
            return false;
        }
        return tag.m_128342_(TAG_ID).equals(id);
    }

    public static boolean isBoundToALock(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_ID);
    }

    public ItemStack m_7968_() {
        ItemStack itemstack = new ItemStack((ItemLike)this);
        return itemstack;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level pLevel, @Nonnull List<Component> pTooltipComponents, @Nonnull TooltipFlag pIsAdvanced) {
        super.m_7373_(stack, pLevel, pTooltipComponents, pIsAdvanced);
        if (stack.m_41784_().m_128441_(TAG_ID)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.cuffed.key.description.bound").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

