/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.mixin;

import com.lazrproductions.cuffed.entity.animation.ArmRestraintAnimationFlags;
import com.lazrproductions.cuffed.entity.animation.HumanoidAnimationHelper;
import com.lazrproductions.cuffed.entity.base.IDetainableEntity;
import com.lazrproductions.cuffed.entity.base.IRestrainableEntity;
import com.lazrproductions.cuffed.restraints.RestraintAPI;
import com.lazrproductions.cuffed.restraints.custom.PilloryRestraint;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin<T extends LivingEntity> {
    @Shadow
    public ModelPart f_102808_;
    @Shadow
    public ModelPart f_102809_;
    @Shadow
    public ModelPart f_102810_;
    @Shadow
    public ModelPart f_102811_;
    @Shadow
    public ModelPart f_102812_;
    @Shadow
    public ModelPart f_102813_;
    @Shadow
    public ModelPart f_102814_;

    @Inject(at={@At(value="HEAD")}, method={"setupAnim"}, cancellable=true)
    private void setupAnim(T entity, float f1, float f2, float f3, float headYRot, float headXRot, CallbackInfo callback) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            IDetainableEntity detainableEntity = (IDetainableEntity)p;
            int detained = detainableEntity.getDetained();
            boolean shouldCancel = false;
            HumanoidModel model = (HumanoidModel)this;
            this.f_102808_.f_104202_ = 0.0f;
            this.f_102810_.f_104202_ = 0.0f;
            if (detained == 0) {
                HumanoidAnimationHelper.animatePilloryDetainedAnimation(entity, (HumanoidModel<LivingEntity>)model, f1, f2, f3, headYRot, headXRot, detainableEntity.getDetainedRotation());
                shouldCancel = true;
            } else if (p instanceof IRestrainableEntity) {
                IRestrainableEntity restrainable = (IRestrainableEntity)p;
                ArmRestraintAnimationFlags armAnimationFlags = RestraintAPI.getArmAnimationFlagByKey(restrainable.getArmRestraintId());
                if (restrainable.getHeadRestraintId() == PilloryRestraint.ID) {
                    p.m_146926_(10.0f);
                }
                if (armAnimationFlags != null) {
                    switch (armAnimationFlags) {
                        case ARMS_TIED_FRONT: {
                            HumanoidAnimationHelper.animateArmsTiedFront(entity, (HumanoidModel<LivingEntity>)model, f1, f2, f3, headYRot, headXRot);
                            shouldCancel = true;
                            break;
                        }
                        case ARMS_TIED_BEHIND: {
                            HumanoidAnimationHelper.animateArmsTiedBack(entity, (HumanoidModel<LivingEntity>)model, f1, f2, f3, headYRot, headXRot);
                            shouldCancel = true;
                            break;
                        }
                    }
                }
            }
            if (shouldCancel) {
                callback.cancel();
            }
        }
    }
}

