/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.packet;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.lazrproductions.lazrslib.common.network.packet.ParameterizedLazrPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class LockpickRestraintPacket
extends ParameterizedLazrPacket {
    int speedIncreasePerPick;
    int progressPerPick;
    int stopCode;
    String restrainedUUID;
    int restraintType;
    String lockpickerUUID;

    public LockpickRestraintPacket(String restrainedUUID, int restraintType, int speedIncreasePerTick, int progressPerPick, String lockpickerUUID) {
        super(new Object[]{speedIncreasePerTick, progressPerPick, -1, restrainedUUID, restraintType, lockpickerUUID});
        this.stopCode = -1;
        this.restrainedUUID = restrainedUUID;
        this.restraintType = restraintType;
        this.speedIncreasePerPick = speedIncreasePerTick;
        this.progressPerPick = progressPerPick;
    }

    public LockpickRestraintPacket(boolean wasFailed, String restrainedUUID, int restraintType, String lockpickerUUID) {
        super(new Object[]{0, 0, wasFailed ? 0 : 2, restrainedUUID, restraintType, lockpickerUUID});
        this.stopCode = wasFailed ? 0 : 2;
        this.restrainedUUID = restrainedUUID;
        this.restraintType = restraintType;
        this.lockpickerUUID = lockpickerUUID;
    }

    public LockpickRestraintPacket(FriendlyByteBuf buf) {
        super(buf);
    }

    public void loadValues(Object[] arg0) {
        this.speedIncreasePerPick = (Integer)arg0[0];
        this.progressPerPick = (Integer)arg0[1];
        this.stopCode = (Integer)arg0[2];
        this.restrainedUUID = (String)arg0[3];
        this.restraintType = (Integer)arg0[4];
        this.lockpickerUUID = (String)arg0[5];
    }

    public void handleClientside(Supplier<NetworkEvent.Context> ctx) {
        Clientside.handleClientside(ctx, this.speedIncreasePerPick, this.progressPerPick, this.stopCode, this.restrainedUUID, this.restraintType, this.lockpickerUUID);
    }

    public void handleServerside(Supplier<NetworkEvent.Context> ctx) {
        Serverside.handleServerside(ctx, this.speedIncreasePerPick, this.progressPerPick, this.stopCode, this.restrainedUUID, this.restraintType, this.lockpickerUUID);
    }

    static class Clientside {
        Clientside() {
        }

        public static void handleClientside(Supplier<NetworkEvent.Context> ctx, int speedIncreasePerPick, int progressPerPick, int stopCode, String restrainedUUID, int restraintType, String lockpickerUUID) {
            if (stopCode <= -1) {
                Minecraft instance = Minecraft.m_91087_();
                CuffedAPI.Lockpicking.beginLockpickingRestraint(instance, restrainedUUID, restraintType, speedIncreasePerPick, progressPerPick);
            }
        }
    }

    static class Serverside {
        Serverside() {
        }

        public static void handleServerside(Supplier<NetworkEvent.Context> ctx, int speedIncreasePerPick, int progressPerPick, int stopCode, String restrainedUUID, int restraintType, String lockpickerUUID) {
            if (stopCode > -1) {
                CuffedAPI.Lockpicking.finishLockpickingRestraint(stopCode == 0, RestraintType.fromInteger(restraintType), UUID.fromString(restrainedUUID), UUID.fromString(lockpickerUUID));
            }
        }
    }
}

