/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.recipes;

import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModRecipes;
import com.lazrproductions.cuffed.items.PosterBlockItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PosterChangeRecipe
extends CustomRecipe {
    public PosterChangeRecipe(ResourceLocation idIn, CraftingBookCategory category) {
        super(idIn, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        return this.isGridValid(inv);
    }

    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess access) {
        if (this.matches(inv, null)) {
            ItemStack posterStack = this.getPosterFromGrid(inv);
            return PosterBlockItem.newItemFromType(PosterBlockItem.getPosterType(posterStack).next());
        }
        return ItemStack.f_41583_;
    }

    public ArrayList<ItemStack> getAllValidItemsInGrid(@Nonnull CraftingContainer inv) {
        ArrayList<ItemStack> validInGrid = new ArrayList<ItemStack>(0);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkingStack = inv.m_8020_(i);
            if (checkingStack.m_41619_() || !checkingStack.m_150930_((Item)ModItems.POSTER_ITEM.get())) continue;
            validInGrid.add(checkingStack);
        }
        return validInGrid;
    }

    public ItemStack getPosterFromGrid(@Nonnull CraftingContainer inv) {
        ArrayList<ItemStack> moldsInGrid = this.getAllValidItemsInGrid(inv);
        return moldsInGrid.get(0);
    }

    public boolean isGridValid(@Nonnull CraftingContainer inv) {
        int numOfPosters = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkingStack = inv.m_8020_(i);
            if (checkingStack.m_41619_()) continue;
            if (checkingStack.m_150930_((Item)ModItems.POSTER_ITEM.get())) {
                ++numOfPosters;
                continue;
            }
            return false;
        }
        return numOfPosters == 1;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.POSTER_CHANGE.get();
    }
}

