/*
 * Decompiled with CFR 0.152.
 */
package org.yoann.stackabletools;

import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import org.yoann.stackabletools.StackableToolsMod;

public class PlayerContext {
    private static final ThreadLocal<class_1657> currentPlayer = new ThreadLocal();

    public static void set(class_1657 player) {
        currentPlayer.set(player);
    }

    public static class_1657 get() {
        return currentPlayer.get();
    }

    public static void clear() {
        currentPlayer.remove();
    }

    public static void giveOrDropIntactTools(class_1657 player, class_1799 intactTools) {
        int remainingCount;
        if (player == null || player.method_37908().field_9236) {
            return;
        }
        class_1661 inventory = player.method_31548();
        int originalCount = remainingCount = intactTools.method_7947();
        int maxStackSize = StackableToolsMod.getConfig().getMaxStackSize();
        int stacksCombined = 0;
        for (int i = 0; i < inventory.method_5439() && remainingCount > 0; ++i) {
            class_1799 slotStack = inventory.method_5438(i);
            if (slotStack.method_7960() || !class_1799.method_31577((class_1799)slotStack, (class_1799)intactTools) || slotStack.method_7919() != 0 || slotStack.method_7947() >= maxStackSize) continue;
            int spaceAvailable = maxStackSize - slotStack.method_7947();
            int toAdd = Math.min(spaceAvailable, remainingCount);
            slotStack.method_7939(slotStack.method_7947() + toAdd);
            remainingCount -= toAdd;
            ++stacksCombined;
        }
        if (remainingCount > 0) {
            class_1799 remaining = intactTools.method_7972();
            remaining.method_7939(remainingCount);
            if (!inventory.method_7394(remaining)) {
                if (StackableToolsMod.getConfig().isLoggingEnabled()) {
                    StackableToolsMod.LOGGER.debug("Player inventory full, dropping {} intact tools", (Object)remainingCount);
                }
                class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), remaining);
                itemEntity.method_6982(0);
                player.method_37908().method_8649((class_1297)itemEntity);
            }
        }
        if ((stacksCombined > 0 || remainingCount < originalCount) && StackableToolsMod.getConfig().isLoggingEnabled()) {
            StackableToolsMod.LOGGER.debug("Returned {} intact tools to player (combined into {} stacks)", (Object)(originalCount - remainingCount), (Object)stacksCombined);
        }
    }
}

