/*
 * Decompiled with CFR 0.152.
 */
package org.yoann.stackabletools.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.yoann.stackabletools.StackableToolsMod;

public class StackableToolsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config/stackabletools.json";
    private static StackableToolsConfig INSTANCE;
    public int maxStackSize = 8;
    public boolean enableLogging = false;

    public static StackableToolsConfig load() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        File configFile = new File(CONFIG_FILE);
        if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
            System.err.println("[StackableTools] Failed to create config directory");
        }
        if (configFile.exists()) {
            StackableToolsConfig stackableToolsConfig;
            FileReader reader = new FileReader(configFile);
            try {
                INSTANCE = (StackableToolsConfig)GSON.fromJson((Reader)reader, StackableToolsConfig.class);
                StackableToolsMod.LOGGER.info("Configuration loaded from {}", (Object)CONFIG_FILE);
                if (StackableToolsConfig.INSTANCE.maxStackSize < 1 || StackableToolsConfig.INSTANCE.maxStackSize > 64) {
                    StackableToolsMod.LOGGER.warn("Invalid maxStackSize value ({}), using default (8)", (Object)StackableToolsConfig.INSTANCE.maxStackSize);
                    StackableToolsConfig.INSTANCE.maxStackSize = 8;
                }
                stackableToolsConfig = INSTANCE;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    StackableToolsMod.LOGGER.error("Failed to load config file, using defaults", (Throwable)e);
                    INSTANCE = new StackableToolsConfig();
                }
            }
            reader.close();
            return stackableToolsConfig;
        } else {
            StackableToolsMod.LOGGER.info("Config file not found, creating default configuration");
            INSTANCE = new StackableToolsConfig();
            INSTANCE.save();
        }
        return INSTANCE;
    }

    public void save() {
        File configFile = new File(CONFIG_FILE);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
            StackableToolsMod.LOGGER.info("Configuration saved to {}", (Object)CONFIG_FILE);
        }
        catch (IOException e) {
            StackableToolsMod.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public static StackableToolsConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StackableToolsConfig();
        }
        return INSTANCE;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public boolean isLoggingEnabled() {
        return this.enableLogging;
    }
}

