/*
 * Decompiled with CFR 0.152.
 */
package org.yoann.stackabletools.mixin;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.yoann.stackabletools.PlayerContext;
import org.yoann.stackabletools.StackableToolsMod;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Unique
    private boolean stackabletools$isProcessingDamage = false;

    @Shadow
    public abstract boolean method_7963();

    @Shadow
    public abstract int method_7947();

    @Shadow
    public abstract void method_7939(int var1);

    @Shadow
    public abstract int method_7919();

    @Shadow
    public abstract void method_7974(int var1);

    @Shadow
    public abstract int method_7936();

    @Shadow
    public abstract class_1799 method_7972();

    @Unique
    private class_1657 stackabletools$findPlayerInStackTrace() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("PlayerEntity") && !className.contains("ServerPlayerEntity")) continue;
        }
        class_1657 player = PlayerContext.get();
        if (player != null) {
            return player;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"setDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetDamage(int damage, CallbackInfo ci) {
        if (this.stackabletools$isProcessingDamage) {
            return;
        }
        if (!this.method_7963() || damage <= 0) return;
        int currentDamage = this.method_7919();
        if (this.method_7947() > 1 && currentDamage == 0) {
            ci.cancel();
            this.stackabletools$isProcessingDamage = true;
            try {
                int stackSize = this.method_7947();
                class_1799 intactTools = this.method_7972();
                intactTools.method_7939(stackSize - 1);
                intactTools.method_7974(0);
                this.method_7939(1);
                this.method_7974(damage);
                class_1657 player = this.stackabletools$findPlayerInStackTrace();
                if (player != null) {
                    if (StackableToolsMod.getConfig().isLoggingEnabled()) {
                        StackableToolsMod.LOGGER.debug("Splitting tool stack: 1 damaged, {} intact returned to player", (Object)intactTools.method_7947());
                    }
                    PlayerContext.giveOrDropIntactTools(player, intactTools);
                    return;
                }
                StackableToolsMod.LOGGER.error("Unable to find player when splitting tool stack!");
                StackableToolsMod.LOGGER.error("The {} intact tools will be temporarily lost.", (Object)intactTools.method_7947());
                if (!StackableToolsMod.getConfig().isLoggingEnabled()) return;
                StackableToolsMod.LOGGER.debug("Stack trace:");
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    StackableToolsMod.LOGGER.debug("  {}", (Object)element.toString());
                }
                return;
            }
            finally {
                this.stackabletools$isProcessingDamage = false;
                PlayerContext.clear();
            }
        } else {
            if (this.method_7947() != 1 || damage < this.method_7936() || !StackableToolsMod.getConfig().isLoggingEnabled()) return;
            StackableToolsMod.LOGGER.debug("Tool breaking with damage {} / {}", (Object)damage, (Object)this.method_7936());
        }
    }
}

