/*
 * Decompiled with CFR 0.152.
 */
package org.timer.speedruntimer;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.timer.speedruntimer.SpeedrunLeaderboardGUI;
import org.timer.speedruntimer.bStats.Metrics;

public final class SpeedRunTimer
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private BossBar bossBar;
    private long startTime;
    private boolean timerRunning;
    private long pauseTime;
    private boolean timerPaused;
    private FileConfiguration config;
    boolean allowPlayerBlock = true;
    private File timerFile;
    private FileConfiguration timerData;
    private final Set<Player> playersExecutingCommand = new HashSet<Player>();
    private File leaderboardFile;
    private SpeedrunLeaderboardGUI leaderboardGUI;
    private FileConfiguration leaderboardData;
    private boolean gameEnded = true;

    public void onEnable() {
        this.loadConfig();
        this.loadTimerData();
        this.loadLeaderboardData();
        this.getCommand("speedrun").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.leaderboardGUI = new SpeedrunLeaderboardGUI(this.leaderboardData);
        this.getServer().getPluginManager().registerEvents((Listener)this.leaderboardGUI, (Plugin)this);
        if (!this.config.getBoolean("createWorldBoder")) {
            Bukkit.getWorld((String)"world").getWorldBorder().setSize((double)this.config.getInt("gameBorder", 50000));
        } else {
            Bukkit.getWorld((String)"world").getWorldBorder().setSize((double)this.config.getInt("lobbyBorder", 10));
        }
        this.LobbySettings();
        Metrics metrics = new Metrics((Plugin)this);
        metrics.addCustomChart(new Metrics.SingleLineChart("players", () -> Bukkit.getOnlinePlayers().size()));
        this.startTime = this.timerData.getLong("startTime", 0L);
        this.pauseTime = this.timerData.getLong("pauseTime", 0L);
        this.timerRunning = this.timerData.getBoolean("timerRunning", false);
        this.timerPaused = this.timerData.getBoolean("timerPaused", false);
        if (this.timerRunning) {
            String bossBarColorName = this.config.getString("bossBarColor", "BLUE");
            BarColor bossBarColor = BarColor.valueOf((String)bossBarColorName);
            this.bossBar = Bukkit.createBossBar((String)"Timer: 00:00:00:000", (BarColor)bossBarColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.bossBar.setProgress(1.0);
            this.bossBar.setVisible(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.bossBar.addPlayer(player);
            }
            new BukkitRunnable(){

                public void run() {
                    if (SpeedRunTimer.this.timerRunning) {
                        SpeedRunTimer.this.updateBossBar();
                    } else {
                        SpeedRunTimer.this.bossBar.removeAll();
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this, 0L, 1L);
        }
    }

    public void onDisable() {
        this.saveTimerData();
    }

    private void loadConfig() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            this.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        block21: {
            try {
                if (!event.getView().getTitle().equals(ChatColor.BOLD + "funcy's SpeedrunTimer Main Menu:")) break block21;
                if (!(event.getWhoClicked() instanceof Player)) {
                    return;
                }
                Player player = (Player)event.getWhoClicked();
                if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
                    event.setCancelled(true);
                }
                switch (event.getRawSlot()) {
                    case 11: {
                        if (this.timerRunning) {
                            player.sendMessage(ChatColor.RED + "[Speedrun Timer] Wrong button :) ");
                            break;
                        }
                        this.timerPaused = false;
                        this.startTime = System.currentTimeMillis();
                        this.gameEnded = false;
                        this.startCountdown(player, 3);
                        if (this.config.getBoolean("refillPlayersHunger")) {
                            for (Player player2 : Bukkit.getOnlinePlayers()) {
                                player2.setFoodLevel(20);
                                player2.setSaturation(20.0f);
                                player2.sendMessage(ChatColor.GRAY + "[funcy's Speedrun Timer] Your hunger and saturation have been filled up!");
                            }
                        }
                        player.closeInventory();
                        break;
                    }
                    case 13: {
                        if (this.timerRunning) {
                            if (!this.timerPaused) {
                                this.timerPaused = true;
                                this.pauseTime = System.currentTimeMillis();
                                this.saveTimerData();
                                Bukkit.broadcastMessage((String)(ChatColor.RED + "[funcy's Speedrun Timer] !!! The Speedrun has paused !!!"));
                                this.bossBar.setTitle("PAUSED");
                                if (!this.config.getBoolean("DoPrompts")) break;
                                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                    onlinePlayer.sendTitle(ChatColor.RED + "Speedrun have been paused!", "", 10, 70, 20);
                                    onlinePlayer.playSound(onlinePlayer.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                }
                            } else {
                                this.timerPaused = false;
                                this.startTime += System.currentTimeMillis() - this.pauseTime;
                                Bukkit.broadcastMessage((String)(ChatColor.RED + "[funcy's Speedrun Timer] The Speedrun has resumed!"));
                                player.closeInventory();
                                if (!this.config.getBoolean("DoPrompts")) break;
                                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                    onlinePlayer.sendTitle(ChatColor.RED + "The Speedrun have resumed!", "", 10, 70, 20);
                                    onlinePlayer.playSound(onlinePlayer.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                }
                            }
                            break;
                        }
                        player.sendMessage("[funcy's Speedrun Timer] Timer is not running.");
                        break;
                    }
                    case 15: {
                        if (!this.timerRunning) break;
                        this.bossBar.removeAll();
                        this.timerRunning = false;
                        this.saveTimerData();
                        if (!this.config.getBoolean("DoPrompts")) break;
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            onlinePlayer.sendTitle(ChatColor.RED + "The Speedrun have ended!", "", 10, 70, 20);
                            onlinePlayer.playSound(onlinePlayer.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                        }
                        break;
                    }
                    case 31: {
                        this.leaderboardGUI.openLeaderboardGUI(player);
                        break;
                    }
                    case 22: {
                        player.closeInventory();
                        player.sendMessage("[funcy's Speedrun Timer] Join the developer's discord: " + ChatColor.LIGHT_PURPLE.toString() + ChatColor.BOLD + "https://discord.gg/CQ9BfSKjy8");
                        break;
                    }
                    case 32: {
                        player.closeInventory();
                        Bukkit.broadcastMessage((String)("[funcy's Speedrun Timer] " + ChatColor.AQUA.toString() + "Feel free to donate the developer any amount! \u2764" + ChatColor.BOLD + " https://www.paypal.com/paypalme/funcybeardev"));
                        break;
                    }
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("An error occurred while processing InventoryClickEvent:");
                Logger.getLogger("If you're still having issues then restart the server or report it to the developer! -> https://discord.gg/CQ9BfSKjy8");
                e.printStackTrace();
            }
        }
    }

    private void loadTimerData() {
        this.timerFile = new File(this.getDataFolder(), "timer.yml");
        if (!this.timerFile.exists()) {
            try {
                this.timerFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.timerData = YamlConfiguration.loadConfiguration((File)this.timerFile);
        this.startTime = this.timerData.getLong("startTime", 0L);
        this.pauseTime = this.timerData.getLong("pauseTime", 0L);
        this.timerRunning = this.timerData.getBoolean("timerRunning", false);
        this.timerPaused = this.timerData.getBoolean("timerPaused", false);
        if (this.timerRunning) {
            String bossBarColorName = this.config.getString("bossBarColor", "BLUE");
            BarColor bossBarColor = BarColor.valueOf((String)bossBarColorName);
            this.bossBar = Bukkit.createBossBar((String)"Timer: 00:00:00:000", (BarColor)bossBarColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.bossBar.setProgress(1.0);
            this.bossBar.setVisible(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.bossBar.addPlayer(player);
            }
            new BukkitRunnable(){

                public void run() {
                    if (SpeedRunTimer.this.timerRunning) {
                        SpeedRunTimer.this.updateBossBar();
                    } else {
                        SpeedRunTimer.this.bossBar.removeAll();
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this, 0L, 1L);
        }
    }

    private void saveTimerData() {
        try {
            this.timerData.set("startTime", (Object)this.startTime);
            this.timerData.set("pauseTime", (Object)this.pauseTime);
            this.timerData.set("timerRunning", (Object)this.timerRunning);
            this.timerData.set("timerPaused", (Object)this.timerPaused);
            this.timerData.save(this.timerFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (sender instanceof Player) {
            this.LobbySettings();
            this.playersExecutingCommand.add((Player)sender);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.playersExecutingCommand.remove(sender), 1L);
            Player player = (Player)sender;
            Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)45, (String)(ChatColor.BOLD + "funcy's SpeedrunTimer Main Menu:"));
            ItemStack StartSpeedrun = new ItemStack(Material.DIAMOND_SWORD);
            ItemMeta startSpeedrun = StartSpeedrun.getItemMeta();
            startSpeedrun.setDisplayName(ChatColor.GREEN.toString() + ChatColor.BOLD + "Start Speedrun");
            startSpeedrun.setLore(Arrays.asList(ChatColor.GRAY + "Start the speedrun timer!"));
            StartSpeedrun.setItemMeta(startSpeedrun);
            inv.setItem(11, StartSpeedrun);
            ItemStack PauseSpeedrun = new ItemStack(Material.GOLD_INGOT);
            ItemMeta pauseSpeedrun = PauseSpeedrun.getItemMeta();
            pauseSpeedrun.setDisplayName(ChatColor.YELLOW.toString() + ChatColor.BOLD + "Pause/Resume Speedrun");
            pauseSpeedrun.setLore(Arrays.asList(ChatColor.GRAY + "Pause speedrun timer!"));
            PauseSpeedrun.setItemMeta(pauseSpeedrun);
            inv.setItem(13, PauseSpeedrun);
            ItemStack StopSpeedrun = new ItemStack(Material.DRAGON_EGG);
            ItemMeta SStopSpeedrun = PauseSpeedrun.getItemMeta();
            SStopSpeedrun.setDisplayName(ChatColor.RED.toString() + ChatColor.BOLD + "Stop Speedrun");
            SStopSpeedrun.setLore(Arrays.asList(ChatColor.RED + "Stop the timer, THIS CHANGE IS IRREVERSIBLE"));
            StopSpeedrun.setItemMeta(SStopSpeedrun);
            inv.setItem(15, StopSpeedrun);
            ItemStack DiscordGUI = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta discordSkull = (SkullMeta)DiscordGUI.getItemMeta();
            discordSkull.setOwningPlayer((OfflinePlayer)player);
            ItemMeta discordGUI = DiscordGUI.getItemMeta();
            discordGUI.setDisplayName(ChatColor.DARK_PURPLE.toString() + ChatColor.BOLD + "Discord");
            discordGUI.setLore(Arrays.asList(ChatColor.GRAY + "Join the developer's discord :D"));
            DiscordGUI.setItemMeta(discordGUI);
            inv.setItem(30, DiscordGUI);
            ItemStack Paypal = new ItemStack(Material.EMERALD);
            ItemMeta paypal = Paypal.getItemMeta();
            paypal.setDisplayName(ChatColor.AQUA.toString() + ChatColor.BOLD + "Paypal Donation");
            paypal.setLore(Arrays.asList(ChatColor.GRAY + "Donate to funcybear!"));
            Paypal.setItemMeta(paypal);
            inv.setItem(32, Paypal);
            ItemStack leaderboard = new ItemStack(Material.ENDER_PEARL);
            ItemMeta leaderboardMeta = leaderboard.getItemMeta();
            leaderboardMeta.setDisplayName(ChatColor.BLUE.toString() + ChatColor.BOLD + "Top 10 Speedruns");
            leaderboardMeta.setLore(Arrays.asList(ChatColor.GRAY + "View top speedrun records"));
            leaderboard.setItemMeta(leaderboardMeta);
            inv.setItem(31, leaderboard);
            inv.setItem(31, SpeedrunLeaderboardGUI.createLeaderboardMenuItem());
            player.openInventory(inv);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.LobbySettings();
        if (this.timerRunning && this.bossBar != null) {
            this.bossBar.addPlayer(player);
            long elapsedTime = this.timerPaused ? this.pauseTime - this.startTime : System.currentTimeMillis() - this.startTime;
            long hours = elapsedTime / 3600000L;
            long minutes = elapsedTime % 3600000L / 60000L;
            long seconds = elapsedTime % 60000L / 1000L;
            long milliseconds = elapsedTime % 1000L;
            player.sendMessage(ChatColor.GREEN + "[Speedrun Timer] Current time: " + String.format("%02d:%02d:%02d:%03d", hours, minutes, seconds, milliseconds));
        }
    }

    private void updateBossBar() {
        if (this.timerPaused) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            this.bossBar.setTitle("PAUSED");
        } else {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            long hours = elapsedTime / 3600000L;
            long minutes = elapsedTime % 3600000L / 60000L;
            long seconds = elapsedTime % 60000L / 1000L;
            long milliseconds = elapsedTime % 1000L;
            this.bossBar.setTitle("Timer: " + String.format("%02d:%02d:%02d:%02d", hours, minutes, seconds, milliseconds));
        }
    }

    private void createBossBar() {
        if (!this.timerRunning) {
            this.startTime = System.currentTimeMillis();
            this.saveTimerData();
            String bossBarColorName = this.config.getString("bossBarColor", "BLUE");
            BarColor bossBarColor = BarColor.valueOf((String)bossBarColorName);
            this.bossBar = Bukkit.createBossBar((String)"Timer: 00:00:00:000", (BarColor)bossBarColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.bossBar.setProgress(1.0);
            this.bossBar.setVisible(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.bossBar.addPlayer(player);
            }
            this.timerRunning = true;
            new BukkitRunnable(){

                public void run() {
                    if (SpeedRunTimer.this.timerRunning) {
                        SpeedRunTimer.this.updateBossBar();
                    } else {
                        SpeedRunTimer.this.bossBar.removeAll();
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this, 0L, 1L);
        }
    }

    private void createNotification() {
        this.createBossBar();
    }

    @EventHandler
    public void onEndTeleport(EntityPortalEnterEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        World.Environment environment = player.getWorld().getEnvironment();
        if (environment.equals((Object)World.Environment.THE_END) && !this.gameEnded) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            long hours = elapsedTime / 3600000L;
            long minutes = elapsedTime % 3600000L / 60000L;
            long seconds = elapsedTime % 60000L / 1000L;
            long milliseconds = elapsedTime % 1000L;
            String name = player.getName();
            long oldTime = this.leaderboardData.getLong("players." + name, Long.MAX_VALUE);
            if (elapsedTime < oldTime) {
                this.leaderboardData.set("players." + name + ".time", (Object)elapsedTime);
                this.leaderboardData.set("players." + name + ".uuid", (Object)player.getUniqueId().toString());
                try {
                    this.leaderboardData.save(new File(this.getDataFolder(), "leaderboard.yml"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String formattedTime = String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds);
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                onlinePlayer.kickPlayer("Player " + name + " beat the game in: " + formattedTime);
            }
            this.gameEnded = true;
            if (this.bossBar != null) {
                this.bossBar.removeAll();
                this.bossBar.setVisible(false);
            }
            this.timerRunning = false;
            this.timerPaused = false;
            this.startTime = 0L;
            this.pauseTime = 0L;
            this.saveTimerData();
        }
    }

    private String formatTime(long hours, long minutes, long seconds) {
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.timerPaused && this.config.getBoolean("PlayerPauseMovement")) {
            Player player = event.getPlayer();
            if (!this.playersExecutingCommand.contains(player)) {
                event.setTo(event.getFrom());
            }
        } else {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (this.timerPaused && this.config.getBoolean("PlayerPauseMovement")) {
            if (event.getEntity() instanceof Player) {
                event.setCancelled(true);
            } else {
                event.setCancelled(false);
            }
        }
    }

    private void startCountdown(Player player, final int seconds) {
        if (!this.config.getBoolean("makeStartingCountdown")) {
            this.createNotification();
            Bukkit.getWorld((String)"world").getWorldBorder().setSize((double)this.config.getInt("gameBorder", 50000));
            return;
        }
        new BukkitRunnable(){
            int timeRemaining;
            {
                this.timeRemaining = seconds;
            }

            public void run() {
                if (this.timeRemaining <= 0) {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        onlinePlayer.sendTitle(ChatColor.GREEN + "GO!", "", 10, 70, 20);
                        onlinePlayer.playSound(onlinePlayer.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                        SpeedRunTimer.this.createNotification();
                        Bukkit.getWorld((String)"world").getWorldBorder().setSize((double)SpeedRunTimer.this.config.getInt("gameBorder", 50000));
                    }
                    SpeedRunTimer.this.allowPlayerBlock = false;
                    this.cancel();
                    return;
                }
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.sendTitle(this.timeRemaining + "s", "", 10, 20, 10);
                    onlinePlayer.playSound(onlinePlayer.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                }
                --this.timeRemaining;
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.allowPlayerBlock && !this.timerRunning) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("[Speedrun Timer] The game hasn't started!");
        }
    }

    public void LobbySettings() {
        this.allowPlayerBlock = !this.config.getBoolean("DontPlayersToBreakBlocks");
        if (this.config.getBoolean("daytimeonstart")) {
            Bukkit.getWorld((String)"world").setTime(1000L);
        }
    }

    private void loadLeaderboardData() {
        this.leaderboardFile = new File(this.getDataFolder(), "leaderboard.yml");
        if (!this.leaderboardFile.exists()) {
            try {
                this.leaderboardFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.leaderboardData = YamlConfiguration.loadConfiguration((File)this.leaderboardFile);
    }
}

