/*
 * Decompiled with CFR 0.152.
 */
package org.timer.speedruntimer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SpeedrunLeaderboardGUI
implements Listener {
    private final FileConfiguration leaderboardData;

    public SpeedrunLeaderboardGUI(FileConfiguration leaderboardData) {
        this.leaderboardData = leaderboardData;
    }

    public void openLeaderboardGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)(ChatColor.BOLD + "\ud83c\udfc1 Top 10 Speedrunners"));
        ConfigurationSection section = this.leaderboardData.getConfigurationSection("players");
        if (section == null) {
            player.sendMessage(ChatColor.RED + "Leaderboard is empty.");
            return;
        }
        List sorted = section.getKeys(false).stream().sorted(Comparator.comparingLong(name -> this.leaderboardData.getLong("players." + name + ".time"))).limit(10L).collect(Collectors.toList());
        for (int i = 0; i < sorted.size(); ++i) {
            String name2 = (String)sorted.get(i);
            long time = this.leaderboardData.getLong("players." + name2 + ".time");
            String uuidStr = this.leaderboardData.getString("players." + name2 + ".uuid");
            UUID uuid = uuidStr != null ? UUID.fromString(uuidStr) : null;
            long hours = time / 3600000L;
            long minutes = time % 3600000L / 60000L;
            long seconds = time % 60000L / 1000L;
            long millis = time % 1000L;
            ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            OfflinePlayer offlinePlayer = uuid != null ? Bukkit.getOfflinePlayer((UUID)uuid) : Bukkit.getOfflinePlayer((String)name2);
            meta.setOwningPlayer(offlinePlayer);
            meta.setDisplayName(ChatColor.GOLD.toString() + (i + 1) + ". " + name2);
            meta.setLore(Arrays.asList(ChatColor.GRAY + String.format("Time: %02d:%02d:%02d.%03d", hours, minutes, seconds, millis)));
            head.setItemMeta((ItemMeta)meta);
            gui.setItem(i + 9, head);
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        try {
            if (event.getView().getTitle().equals(ChatColor.BOLD + "\ud83c\udfc1 Top 10 Speedrunners")) {
                event.setCancelled(true);
                return;
            }
            if (event.getView().getTitle().equals(ChatColor.BOLD + "funcy's SpeedrunTimer Main Menu:")) {
                if (!(event.getWhoClicked() instanceof Player)) {
                    return;
                }
                Player player = (Player)event.getWhoClicked();
                if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
                    event.setCancelled(true);
                }
                switch (event.getRawSlot()) {
                    case 29: {
                        this.openLeaderboardGUI(player);
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Error in InventoryClickEvent:");
            e.printStackTrace();
        }
    }

    public static ItemStack createLeaderboardMenuItem() {
        ItemStack leaderboard = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta leaderboardMeta = leaderboard.getItemMeta();
        leaderboardMeta.setDisplayName(ChatColor.BLUE.toString() + ChatColor.BOLD + "Top 10 Speedruns");
        leaderboardMeta.setLore(Arrays.asList(ChatColor.GRAY + "View top speedrun records"));
        leaderboard.setItemMeta(leaderboardMeta);
        return leaderboard;
    }
}

