/*
 * Decompiled with CFR 0.152.
 */
package net.stardomga.stardomssky;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7924;
import net.stardomga.stardomssky.armor.ModArmorMaterials;
import net.stardomga.stardomssky.blocks.ModBlocks;
import net.stardomga.stardomssky.entity.ModEntities;
import net.stardomga.stardomssky.entity.block.ModBlockEntityTypes;
import net.stardomga.stardomssky.entity.custom.AbyssEntity;
import net.stardomga.stardomssky.items.ModItemGroups;
import net.stardomga.stardomssky.items.ModItems;
import net.stardomga.stardomssky.portal.ModPortals;
import net.stardomga.stardomssky.tags.ModTags;
import net.stardomga.stardomssky.worldgen.ModBiomeKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stardomssky
implements ModInitializer {
    public static final String MOD_ID = "stardomssky";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stardomssky");
    public static final class_5321<class_6796> SAPPHIRE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"stardomssky", (String)"sapphire"));
    private static final Set<class_2960> VANILLA_DIMENSIONS = Set.of(class_2960.method_60655((String)"minecraft", (String)"overworld"), class_2960.method_60655((String)"minecraft", (String)"the_nether"), class_2960.method_60655((String)"minecraft", (String)"the_end"));

    public void onInitialize() {
        ModArmorMaterials.registerArmorMaterials();
        ModBlocks.registerModBlocks();
        ModItems.registerModItems();
        ModItemGroups.registerItemGroups();
        ModBlockEntityTypes.registerBlockEntities();
        ModPortals.registerPortals();
        ModTags.registerTags();
        FabricDefaultAttributeRegistry.register(ModEntities.ABYSS, (class_5132.class_5133)AbyssEntity.createAbyssAttributes());
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomeKeys.ABYSSAL_PLAINS}), (class_2893.class_2895)class_2893.class_2895.field_13176, SAPPHIRE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{ModBiomeKeys.FUNGAL_PLAINS}), (class_2893.class_2895)class_2893.class_2895.field_13176, SAPPHIRE);
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            class_2338 clickedPos = hitResult.method_17777();
            if (player.method_5998(hand).method_7909() != stardom.extremeend.item.ModItems.DRACONIC_SOUL || world.method_8320(clickedPos).method_26204() != ModBlocks.MYSTERIOUS_END_STONE) {
                return class_1269.field_5811;
            }
            for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                    class_2338 center;
                    if (!this.isValidFrameOffset(xOffset, zOffset) || !this.validatePortalFrame(world, center = clickedPos.method_10069(-xOffset, 0, -zOffset)) || !this.validatePortalCenter(world, center)) continue;
                    this.activatePortal(world, center);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                this.checkAndTeleport(player);
            }
        });
    }

    private void checkAndTeleport(class_3222 player) {
        class_3218 world = player.method_51469();
        class_2960 dimensionId = world.method_27983().method_29177();
        if (!this.isVanillaDimension(dimensionId) && player.method_23318() < -60.0) {
            this.teleportToOverworld(player);
        }
    }

    private boolean isVanillaDimension(class_2960 dimensionId) {
        return VANILLA_DIMENSIONS.contains(dimensionId);
    }

    private void teleportToOverworld(class_3222 player) {
        class_3218 overworld = player.method_51469().method_8503().method_3847(class_1937.field_25179);
        if (overworld == null) {
            return;
        }
        double x = player.method_23317();
        double z = player.method_23321();
        class_2170 commandManager = Objects.requireNonNull(player.method_51469().method_8503()).method_3734();
        class_2168 commandSource = player.method_51469().method_8503().method_3739();
        commandManager.method_44252(commandSource, "execute as " + player.method_5477().getString() + " in minecraft:overworld run tp @s " + player.method_24515().method_10263() + " 300 " + player.method_24515().method_10260());
    }

    private boolean isValidFrameOffset(int xOffset, int zOffset) {
        return !(Math.abs(xOffset) != 2 && Math.abs(zOffset) != 2 || Math.abs(xOffset) == 2 && Math.abs(zOffset) == 2);
    }

    private boolean validatePortalFrame(class_1937 world, class_2338 center) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                class_2338 checkPos;
                if (!this.isValidFrameOffset(x, z) || world.method_8320(checkPos = center.method_10069(x, 0, z)).method_27852(ModBlocks.MYSTERIOUS_END_STONE)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validatePortalCenter(class_1937 world, class_2338 center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 checkPos = center.method_10069(x, 0, z);
                if (world.method_8320(checkPos).method_26215()) continue;
                return false;
            }
        }
        return true;
    }

    private void activatePortal(class_1937 world, class_2338 center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 fillPos = center.method_10069(x, 0, z);
                world.method_8501(fillPos, ModBlocks.ABYSSAL_PORTAL.method_9564());
            }
        }
    }
}

