/*
 * Decompiled with CFR 0.152.
 */
package sleeper.integrations;

import dev.geco.gsit.api.GSitAPI;
import dev.geco.gsit.api.event.PlayerPoseEvent;
import dev.geco.gsit.api.event.PlayerStopPoseEvent;
import dev.geco.gsit.model.PoseType;
import java.text.DecimalFormat;
import net.kyori.adventure.audience.Audience;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import sleeper.main.Main;
import sleeper.main.MessageHandler;
import sleeper.main.Scheduler;
import sleeper.main.Voting;

public class GSitHandler
implements Listener {
    DecimalFormat dfrmt = new DecimalFormat();
    Main plugin;
    Scheduler scheduler;
    Voting voting;
    MessageHandler messageFormatting;
    boolean poseToSleep = false;

    public GSitHandler(Main plugin, Scheduler scheduler, Voting voting, MessageHandler messageFormatting) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.voting = voting;
        this.messageFormatting = messageFormatting;
        this.dfrmt.setMaximumFractionDigits(2);
    }

    @EventHandler
    public void onGSitPoseStart(PlayerPoseEvent event) {
        if (!this.poseToSleep) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (world.getTime() < this.plugin.nightTime) {
            return;
        }
        PoseType pose = event.getPose().getPoseType();
        if (pose != PoseType.LAY) {
            return;
        }
        this.scheduler.runDelayedTask(() -> {
            PoseType latestPose = GSitAPI.getPoseByPlayer((Player)player).getPoseType();
            if (latestPose == null || latestPose != PoseType.LAY) {
                return;
            }
            if (this.voting.blockBedsAfterVoting && this.voting.getVotingWorlds().contains(player.getWorld().getName()) && this.voting.hasVoted(player)) {
                this.voting.voteYes(player);
                return;
            }
            this.plugin.sleep(player, true);
        }, 20L * this.plugin.delaySeconds + 1L);
    }

    @EventHandler
    public void onGSitPoseStop(PlayerStopPoseEvent event) {
        if (!this.poseToSleep) {
            return;
        }
        Player player = event.getPlayer();
        Audience audience = this.plugin.adventure().player(player);
        PoseType pose = event.getPose().getPoseType();
        if (pose != PoseType.LAY) {
            return;
        }
        String worldName = player.getWorld().getName();
        float wsleeping = this.plugin.getSleepingWorlds().getOrDefault(worldName, Float.valueOf(0.0f)).floatValue();
        float wonline = this.plugin.getPlayersOnline().getOrDefault(worldName, Float.valueOf(0.0f)).floatValue();
        int countNeeded = (int)Math.ceil((double)wonline * ((double)this.plugin.skipPercentage / 100.0));
        if (wsleeping > 0.0f) {
            this.plugin.getSleepingWorlds().put(worldName, Float.valueOf(wsleeping - 1.0f));
        }
        if (!this.plugin.getRecentlySkipped().contains(worldName) && this.plugin.getWorldSleepers(worldName).contains(player.getUniqueId())) {
            audience.sendMessage(this.messageFormatting.parseMessage(this.plugin.sleepInfo.replace("%percent%", this.dfrmt.format(wsleeping / wonline * 100.0f) + "%").replace("%count_needed%", this.dfrmt.format(countNeeded)).replace("%count%", this.dfrmt.format(wsleeping))));
        }
        this.plugin.getWorldSleepers(worldName).remove(player.getUniqueId());
    }

    public void loadConfig(FileConfiguration config) {
        this.poseToSleep = config.getBoolean("GSitPoseToSleep");
    }
}

