/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import sleeper.main.Main;
import sleeper.main.MessageHandler;
import sleeper.main.Voting;

public class Commands
implements CommandExecutor {
    Main plugin;
    MessageHandler messageHandler;
    Voting voting;
    String msgPlayerNotFound = "&c%player% not found.";
    String msgSelfIgnoreOff = "&aYou are no longer ignored from sleeping.";
    String msgSelfIgnoreOn = "&cYou are now ignored from sleeping.";
    String msgOtherIgnoreOff = "&a%player% is no longer ignored from sleeping.";
    String msgOtherIgnoreOn = "&c%player% is now ignored from sleeping.";
    String msgOtherAlreadyIgnored = "&c%player% is already ignored from sleeping.";
    String msgInvalidState = "&c%input% is not TRUE or FALSE.";
    String msgConfigReloaded = "&aSleep config reloaded.";
    String msgOnlyPlayers = "&cThis command can only be run by players.";
    String sleepHelpList = "&cInvalid command, valid subcommands are: ";

    public Commands(Main plugin, Voting voting, MessageHandler messageFormatting) {
        this.plugin = plugin;
        this.voting = voting;
        this.messageHandler = messageFormatting;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String command, String[] args) {
        Audience audience = this.plugin.adventure().sender(sender);
        switch (cmd.getName().toLowerCase()) {
            case "sleep": {
                if (args.length < 1) {
                    audience.sendMessage(this.messageHandler.parseMessage(this.playerHelpMsg(sender)));
                    break;
                }
                switch (args[0].toLowerCase()) {
                    case "ignore": {
                        if (!this.hasPermission(sender, "sleeper.ignore")) {
                            return true;
                        }
                        if (args.length < 2) {
                            if (!this.isPlayer(sender)) {
                                return true;
                            }
                            UUID uuid = ((Player)sender).getUniqueId();
                            if (this.plugin.ignorePlayers.contains(uuid)) {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgSelfIgnoreOff));
                                this.plugin.ignorePlayers.remove(uuid);
                            } else {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgSelfIgnoreOn));
                                this.plugin.ignorePlayers.add(uuid);
                            }
                        } else if (args.length < 3) {
                            String targetName = args[1];
                            Player target = Bukkit.getPlayer((String)targetName);
                            if (target == null) {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgPlayerNotFound.replaceAll("%player%", targetName)));
                            } else if (this.plugin.ignorePlayers.contains(target.getUniqueId())) {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgOtherIgnoreOff.replaceAll("%player%", target.getName())));
                                this.plugin.ignorePlayers.remove(target.getUniqueId());
                            } else {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgOtherIgnoreOn.replaceAll("%player%", target.getName())));
                                this.plugin.ignorePlayers.add(target.getUniqueId());
                            }
                        } else {
                            String targetName = args[1];
                            String stateString = args[2].toUpperCase();
                            Player target = Bukkit.getPlayer((String)targetName);
                            if (target == null) {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgPlayerNotFound.replaceAll("%player%", targetName)));
                            } else if (!stateString.equals("TRUE") && !stateString.equals("FALSE")) {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgInvalidState.replaceAll("%input%", stateString)));
                            } else if (stateString.equals("TRUE")) {
                                if (!this.plugin.ignorePlayers.contains(target.getUniqueId())) {
                                    audience.sendMessage(this.messageHandler.parseMessage(this.msgOtherIgnoreOn.replaceAll("%player%", target.getName())));
                                    this.plugin.ignorePlayers.add(target.getUniqueId());
                                } else {
                                    audience.sendMessage(this.messageHandler.parseMessage(this.msgOtherAlreadyIgnored.replaceAll("%player%", target.getName())));
                                }
                            } else {
                                audience.sendMessage(this.messageHandler.parseMessage(this.msgOtherIgnoreOff.replaceAll("%player%", target.getName())));
                                this.plugin.ignorePlayers.remove(target.getUniqueId());
                            }
                        }
                        return true;
                    }
                    case "reload": {
                        if (!this.hasPermission(sender, "sleeper.reload")) {
                            return true;
                        }
                        this.plugin.loadConfig();
                        audience.sendMessage(this.messageHandler.parseMessage(this.msgConfigReloaded));
                        return true;
                    }
                }
                if (!this.isPlayer(sender)) {
                    return true;
                }
                Player player = (Player)sender;
                switch (args[0].toLowerCase()) {
                    case "yes": {
                        if (!this.hasPermission((CommandSender)player, "sleeper.vote")) break;
                        this.voting.voteYes(player);
                        break;
                    }
                    case "no": {
                        if (!this.hasPermission((CommandSender)player, "sleeper.vote")) break;
                        this.voting.voteNo(player);
                        break;
                    }
                    case "votes": {
                        if (!this.hasPermission((CommandSender)player, "sleeper.vote")) break;
                        this.voting.showVotes(player);
                        break;
                    }
                    case "debug": {
                        if (!this.hasPermission(sender, "sleeper.data")) break;
                        if (this.plugin.debugPlayers.contains(player.getUniqueId())) {
                            audience.sendMessage(((TextComponent)Component.text("DEBUG: ").color(NamedTextColor.YELLOW)).append(Component.text("Debug disabled").color(NamedTextColor.GRAY)));
                            this.plugin.debugPlayers.remove(player.getUniqueId());
                        } else {
                            audience.sendMessage(((TextComponent)Component.text("DEBUG: ").color(NamedTextColor.YELLOW)).append(Component.text("Debug enabled").color(NamedTextColor.GRAY)));
                            this.plugin.debugPlayers.add(player.getUniqueId());
                        }
                        audience.sendMessage(Component.text("Sleep data:").color(NamedTextColor.RED));
                        if (player.getGameMode().equals((Object)GameMode.SPECTATOR) || player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                            audience.sendMessage(Component.text("Note: you will be ignored from sleep calculations in spectator or creative mode.").color(NamedTextColor.GRAY));
                        }
                        audience.sendMessage(Component.text("Sleeping per world: ").color(NamedTextColor.GREEN));
                        this.plugin.sleepingWorlds.keySet().forEach(world -> audience.sendMessage(Component.text(world + " - " + this.plugin.sleepingWorlds.get(world).toString()).color(NamedTextColor.GRAY)));
                        audience.sendMessage(Component.text("Latest 'online' player count per world: ").color(NamedTextColor.GREEN));
                        this.plugin.playersOnline.keySet().forEach(world -> audience.sendMessage(Component.text(world + " - " + this.plugin.playersOnline.get(world).toString()).color(NamedTextColor.GRAY)));
                        audience.sendMessage(((TextComponent)Component.text("True online player count: ").color(NamedTextColor.GREEN)).append(Component.text(Bukkit.getOnlinePlayers().size()).color(NamedTextColor.GRAY)));
                        audience.sendMessage(((TextComponent)Component.text("Skipping: ").color(NamedTextColor.GREEN)).append(Component.text(this.plugin.skipping.toString()).color(NamedTextColor.GRAY)));
                        int onlineIgnored = this.plugin.getOnlineIgnorers().size();
                        audience.sendMessage(((TextComponent)Component.text("Ignored player count: ").color(NamedTextColor.GREEN)).append(Component.text(onlineIgnored).color(NamedTextColor.GRAY)));
                        audience.sendMessage(Component.text("Ignoring players: ").color(NamedTextColor.GREEN));
                        this.plugin.getOnlineIgnorers().forEach(p -> audience.sendMessage(Component.text(p.getName()).color(NamedTextColor.GRAY)));
                        break;
                    }
                    default: {
                        audience.sendMessage(this.messageHandler.parseMessage(this.playerHelpMsg((CommandSender)player)));
                        break;
                    }
                }
                break;
            }
            default: {
                audience.sendMessage(this.messageHandler.parseMessage(this.playerHelpMsg(sender)));
            }
        }
        return true;
    }

    private boolean isPlayer(CommandSender sender) {
        Audience audience = this.plugin.adventure().sender(sender);
        if (!(sender instanceof Player)) {
            audience.sendMessage(this.messageHandler.parseMessage(this.msgOnlyPlayers));
            return false;
        }
        return true;
    }

    private boolean hasPermission(CommandSender player, String permission) {
        Audience audience = this.plugin.adventure().sender(player);
        if (!player.hasPermission(permission)) {
            audience.sendMessage(this.messageHandler.parseMessage(this.plugin.noPermission));
            return false;
        }
        return true;
    }

    private String playerHelpMsg(CommandSender player) {
        StringJoiner builder = new StringJoiner(", ");
        if (player.hasPermission("sleeper.vote")) {
            builder.add("yes, no, votes");
        }
        if (player.hasPermission("sleeper.ignore")) {
            builder.add("ignore");
        }
        if (player.hasPermission("sleeper.reload")) {
            builder.add("reload");
        }
        return this.sleepHelpList + builder.toString();
    }

    public void loadConfig(FileConfiguration config) {
        this.msgPlayerNotFound = config.getString("PlayerNotFound");
        this.msgSelfIgnoreOff = config.getString("SelfIgnoreOff");
        this.msgSelfIgnoreOn = config.getString("SelfIgnoreOn");
        this.msgOtherIgnoreOff = config.getString("OtherIgnoreOff");
        this.msgOtherIgnoreOn = config.getString("OtherIgnoreOn");
        this.msgOtherAlreadyIgnored = config.getString("OtherAlreadyIgnored");
        this.msgInvalidState = config.getString("InvalidState");
        this.msgConfigReloaded = config.getString("ConfigReloaded");
        this.msgOnlyPlayers = config.getString("OnlyPlayers");
        this.sleepHelpList = config.getString("SleepHelpList");
    }
}

