/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.text.DecimalFormat;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import sleeper.main.Main;
import sleeper.main.MessageHandler;
import sleeper.main.Scheduler;
import sleeper.main.Voting;

public class EventHandlers
implements Listener {
    DecimalFormat dfrmt = new DecimalFormat();
    Main plugin;
    Scheduler scheduler;
    Voting voting;
    MessageHandler messageHandler;

    public EventHandlers(Main plugin, Scheduler scheduler, Voting voting, MessageHandler messageFormatting) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.voting = voting;
        this.messageHandler = messageFormatting;
        this.dfrmt.setMaximumFractionDigits(2);
    }

    @EventHandler
    public void onBedEnter(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        this.scheduler.runDelayedTask(() -> {
            if (!player.isSleeping()) {
                return;
            }
            if (this.voting.blockBedsAfterVoting && this.voting.votingWorlds.contains(player.getWorld().getName()) && this.voting.hasVoted(player)) {
                event.setCancelled(true);
                this.voting.voteYes(player);
                return;
            }
            this.plugin.sleep(player, false);
        }, 20L * this.plugin.delaySeconds + 1L);
    }

    @EventHandler
    public void onBedExit(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        float wsleeping = this.plugin.sleepingWorlds.getOrDefault(worldName, Float.valueOf(0.0f)).floatValue();
        float wonline = this.plugin.playersOnline.getOrDefault(worldName, Float.valueOf(0.0f)).floatValue();
        int countNeeded = (int)Math.ceil((double)wonline * ((double)this.plugin.skipPercentage / 100.0));
        if (wsleeping > 0.0f) {
            this.plugin.sleepingWorlds.put(worldName, Float.valueOf(wsleeping - 1.0f));
        }
        if (!this.plugin.recentlySkipped.contains(worldName)) {
            this.messageHandler.sendMessage(player, this.plugin.sleepInfo.replace("%percent%", this.dfrmt.format(wsleeping / wonline * 100.0f) + "%").replace("%count_needed%", this.dfrmt.format(countNeeded)).replace("%count%", this.dfrmt.format(wsleeping)));
        }
        this.plugin.getWorldSleepers(worldName).remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        float wsleeping;
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        if (player.isSleeping() && (wsleeping = this.plugin.sleepingWorlds.getOrDefault(worldName, Float.valueOf(0.0f)).floatValue()) > 0.0f) {
            this.plugin.sleepingWorlds.put(worldName, Float.valueOf(wsleeping - 1.0f));
        }
        this.plugin.getWorldSleepers(worldName).remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        if (this.plugin.ignorePlayers.contains(player.getUniqueId())) {
            float wsleeping = this.plugin.sleepingWorlds.getOrDefault(worldName, Float.valueOf(0.0f)).floatValue();
            float wonline = this.plugin.playersOnline.getOrDefault(worldName, Float.valueOf(0.0f)).floatValue();
            int countNeeded = (int)Math.ceil((double)wonline * ((double)this.plugin.skipPercentage / 100.0));
            this.messageHandler.sendMessage(player, this.plugin.ignored.replace("%percent%", this.dfrmt.format(wsleeping / wonline * 100.0f) + "%").replace("%count_needed%", this.dfrmt.format(countNeeded)).replace("%count%", this.dfrmt.format(wsleeping)));
        }
    }
}

