/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import com.earth2me.essentials.Essentials;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import sleeper.bstats.bukkit.Metrics;
import sleeper.integrations.GSitHandler;
import sleeper.main.CommandCompletion;
import sleeper.main.Commands;
import sleeper.main.EventHandlers;
import sleeper.main.MessageHandler;
import sleeper.main.Scheduler;
import sleeper.main.UpdateChecker;
import sleeper.main.Voting;

public class Main
extends JavaPlugin {
    MessageHandler messageHandler;
    Voting voting;
    EventHandlers eventhandlers;
    Commands commands;
    Scheduler scheduler;
    GSitHandler gSitHandler;
    Essentials essentials;
    DecimalFormat dfrmt = new DecimalFormat();
    Random random = new Random();
    private BukkitAudiences adventure;
    boolean useAnimation = true;
    public int skipPercentage = 25;
    int skipSpeed = 100;
    boolean broadcastSleepInfo = false;
    boolean delaySleep = false;
    public long delaySeconds = 0L;
    boolean actionbarMessages = false;
    boolean persistentSleepInfo = false;
    int persistenceTime = 30;
    long dayTime = 0L;
    public long nightTime = 12542L;
    boolean ignoreAFKPlayers = true;
    boolean checkUpdates = true;
    ArrayList<String> skipping = new ArrayList();
    ArrayList<String> recentlySkipped = new ArrayList();
    HashMap<String, Integer> skipWorlds = new HashMap();
    ArrayList<UUID> ignorePlayers = new ArrayList();
    ArrayList<UUID> debugPlayers = new ArrayList();
    HashMap<String, Float> sleepingWorlds = new HashMap();
    HashMap<String, Float> playersOnline = new HashMap();
    HashMap<String, ArrayList<UUID>> worldSleepers = new HashMap();
    HashMap<String, Integer> worldLatestSleepAge = new HashMap();
    HashMap<String, String> worldLatestSleepMessage = new HashMap();
    BossBar bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
    public String sleepInfo = "&aSleep > &7 %percent% (%count%) out of a minimum of 25% sleeping.";
    List<String> nightSkip = List.of("&aSleep > &7At least 25% of online users sleeping (%count%), skipping the night.");
    String ignored = "&cSleep > &7You are still being ignored for sleep calculations!";
    String noPermission = "&cYou don't have permission for that.";

    public @NonNull BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info(pdfFile.getName() + " Has Been Disabled!");
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info(pdfFile.getName() + " Version " + pdfFile.getVersion() + " Has Been Enabled!");
        this.adventure = BukkitAudiences.create((Plugin)this);
        int pluginId = 15317;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        PluginManager pm = this.getServer().getPluginManager();
        this.scheduler = new Scheduler(this);
        this.messageHandler = new MessageHandler(this);
        this.voting = new Voting(this, this.messageHandler);
        this.eventhandlers = new EventHandlers(this, this.scheduler, this.voting, this.messageHandler);
        this.commands = new Commands(this, this.voting, this.messageHandler);
        this.getCommand("sleep").setExecutor((CommandExecutor)this.commands);
        this.getCommand("sleep").setTabCompleter((TabCompleter)new CommandCompletion());
        pm.registerEvents((Listener)this.eventhandlers, (Plugin)this);
        StringJoiner integrationsFound = new StringJoiner(", ", "", ".");
        if (pm.getPlugin("GSit") != null) {
            this.gSitHandler = new GSitHandler(this, this.scheduler, this.voting, this.messageHandler);
            pm.registerEvents((Listener)this.gSitHandler, (Plugin)this);
            integrationsFound.add("GSit");
        }
        if (pm.getPlugin("Essentials") != null) {
            this.essentials = (Essentials)pm.getPlugin("Essentials");
            integrationsFound.add("Essentials");
        }
        if (integrationsFound.length() != 1) {
            this.getLogger().info("Loaded integrations for: " + integrationsFound.toString());
        } else {
            this.getLogger().info("Found no plugin integrations.");
        }
        this.setConfig();
        this.loadConfig();
        this.dfrmt.setMaximumFractionDigits(2);
        this.scheduler.runRepeatingTask(() -> {
            for (String worldName : new ArrayList<String>(this.skipping)) {
                if (!this.useAnimation) continue;
                World world = Bukkit.getWorld((String)worldName);
                long time = world.getTime();
                world.setTime(time + (long)this.skipSpeed);
                world.setStorm(false);
                if (time >= this.dayTime + 2000L || time < this.dayTime) continue;
                this.messageHandler.broadcastDebug("Looks like it's time < dayTime+2000, stop the animation.");
                this.skipping.remove(worldName);
                this.scheduler.runDelayedTask(() -> {
                    this.sleepingWorlds.put(worldName, Float.valueOf(0.0f));
                    this.recentlySkipped.remove(worldName);
                }, 20L);
            }
            for (String worldName : this.worldLatestSleepAge.keySet()) {
                int age = this.worldLatestSleepAge.get(worldName);
                if (age < this.persistenceTime * 20) {
                    this.worldLatestSleepAge.replace(worldName, age + 1);
                    continue;
                }
                this.worldLatestSleepAge.remove(worldName);
                this.worldLatestSleepMessage.remove(worldName);
            }
            this.voting.tick();
        }, 1L, 1L);
        this.scheduler.runRepeatingTask(() -> {
            for (String worldName : this.worldSleepers.keySet()) {
                World world = Bukkit.getWorld((String)worldName);
                long time = world.getTime();
                if (time >= this.dayTime + 2000L || time < this.dayTime) continue;
                this.worldSleepers.get(worldName).clear();
                this.worldLatestSleepAge.remove(worldName);
                this.worldLatestSleepMessage.remove(worldName);
            }
            for (String worldName : this.worldLatestSleepAge.keySet()) {
                if (!this.worldLatestSleepMessage.containsKey(worldName)) {
                    return;
                }
                if (!this.persistentSleepInfo) {
                    return;
                }
                if (!this.actionbarMessages) {
                    return;
                }
                String msg = this.worldLatestSleepMessage.get(worldName);
                if (!this.broadcastSleepInfo) {
                    for (UUID uuid : this.worldSleepers.get(worldName)) {
                        this.messageHandler.sendMessage(Bukkit.getPlayer((UUID)uuid), msg);
                    }
                    continue;
                }
                for (Player player : Bukkit.getWorld((String)worldName).getPlayers()) {
                    this.messageHandler.sendMessage(player, msg);
                }
            }
        }, 2L, 20L);
    }

    public void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.useAnimation = config.getBoolean("UseAnimation");
        this.skipPercentage = config.getInt("SkipPercentage");
        this.skipSpeed = config.getInt("SkipSpeed");
        this.sleepInfo = config.getString("SleepInfo");
        this.nightSkip = config.isList("NightSkip") ? config.getStringList("NightSkip") : List.of(config.getString("NightSkip"));
        this.ignored = config.getString("Ignored");
        this.noPermission = config.getString("NoPermission");
        this.broadcastSleepInfo = config.getBoolean("BroadcastSleepInfo");
        this.delaySeconds = config.getLong("DelaySeconds");
        this.delaySleep = config.getBoolean("DelaySleep");
        this.actionbarMessages = config.getBoolean("ActionbarMessages");
        this.persistentSleepInfo = config.getBoolean("PersistentSleepInfo");
        this.persistenceTime = config.getInt("PersistenceTime");
        this.dayTime = config.getLong("DayTime");
        this.nightTime = config.getLong("NightTime");
        if (!this.delaySleep) {
            this.delaySeconds = 0L;
        }
        this.checkUpdates = config.getBoolean("CheckForUpdates");
        this.ignoreAFKPlayers = config.getBoolean("IgnoreAFKPlayers");
        this.messageHandler.loadConfig(config);
        this.voting.loadConfig(config);
        this.commands.loadConfig(config);
        if (this.gSitHandler != null) {
            this.gSitHandler.loadConfig(config);
        }
        if (this.checkUpdates) {
            this.updateChecker();
        }
    }

    public void setConfig() {
        File f = new File(String.valueOf(this.getDataFolder()) + File.separator + "config.yml");
        if (f.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        try (InputStream defConfigStream = this.getResource("config.yml");
             InputStreamReader reader = new InputStreamReader(defConfigStream, StandardCharsets.UTF_8);){
            YamlConfiguration defconf = YamlConfiguration.loadConfiguration((Reader)reader);
            config.addDefaults((Configuration)defconf);
            config.setDefaults((Configuration)defconf);
            this.saveDefaultConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateChecker() {
        new UpdateChecker(this, this.scheduler, 102406).getVersion(version -> {
            if (!this.getDescription().getVersion().equals(version)) {
                this.getLogger().warning("There is a new update available. New version is " + version + " and you are on " + this.getDescription().getVersion() + ".");
            }
        });
    }

    public void sleep(Player player, boolean skipSleepCheck) {
        Audience audience = this.adventure().player(player);
        World world = player.getWorld();
        String pWorld = world.getName();
        Main plugin = this;
        if (!this.worldSleepers.keySet().contains(pWorld)) {
            this.worldSleepers.put(pWorld, new ArrayList());
        }
        if (this.ignorePlayers.contains(player.getUniqueId())) {
            return;
        }
        this.scheduler.runDelayedTask(() -> {
            if (player.isOnline() && (player.isSleeping() || skipSleepCheck)) {
                float wonline = this.onlinePlayers(pWorld);
                float wsleeping = this.sleepingWorlds.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue();
                this.sleepingWorlds.put(pWorld, Float.valueOf(wsleeping += 1.0f));
                this.worldSleepers.get(pWorld).add(player.getUniqueId());
                this.worldLatestSleepAge.put(pWorld, 0);
                float percentage = wsleeping / wonline * 100.0f;
                int countNeeded = (int)Math.ceil((double)wonline * ((double)this.skipPercentage / 100.0));
                if (percentage > 100.0f) {
                    percentage = 100.0f;
                }
                if (this.debugPlayers.contains(player.getUniqueId())) {
                    audience.sendMessage(((TextComponent)Component.text("DEBUG: ").color(NamedTextColor.YELLOW)).append(Component.text("eventhandlers.sleeping: ").color(NamedTextColor.GRAY)));
                    this.sleepingWorlds.keySet().forEach(lworld -> audience.sendMessage(Component.text(this.sleepingWorlds.get(lworld).toString()).color(NamedTextColor.GRAY)));
                    audience.sendMessage(((TextComponent)Component.text("DEBUG: ").color(NamedTextColor.YELLOW)).append(Component.text("eventhandlers.playersOnline: ").color(NamedTextColor.GRAY)));
                    this.playersOnline.keySet().forEach(lworld -> audience.sendMessage(Component.text(this.playersOnline.get(lworld).toString()).color(NamedTextColor.GRAY)));
                    audience.sendMessage(((TextComponent)Component.text("DEBUG: ").color(NamedTextColor.YELLOW)).append(Component.text("skipping: " + this.skipping.toString()).color(NamedTextColor.GRAY)));
                    audience.sendMessage(((TextComponent)Component.text("DEBUG: ").color(NamedTextColor.YELLOW)).append(Component.text("voting: " + this.voting.votingWorlds.toString()).color(NamedTextColor.GRAY)));
                }
                String sleepInfoMsg = this.sleepInfo.replace("%percent%", this.dfrmt.format(percentage) + "%").replace("%count%", this.dfrmt.format(wsleeping)).replace("%count_needed%", this.dfrmt.format(countNeeded)).replace("%player%", player.getName());
                this.worldLatestSleepMessage.put(pWorld, sleepInfoMsg);
                if (!this.broadcastSleepInfo) {
                    this.messageHandler.sendMessage(player, sleepInfoMsg);
                } else {
                    for (Player players : world.getPlayers()) {
                        this.messageHandler.sendMessage(players, sleepInfoMsg);
                    }
                }
                if (this.debugPlayers.contains(player.getUniqueId())) {
                    this.messageHandler.sendDebug(player, "Checking if should skip....");
                    this.messageHandler.sendDebug(player, "sleeping/onlineplayers : " + wsleeping / wonline);
                }
                if (this.voting.useVote) {
                    this.voting.startVote(player);
                    this.voting.voteYes(player);
                }
                if (percentage >= (float)this.skipPercentage && !this.skipping.contains(pWorld)) {
                    this.messageHandler.broadcastDebug("Skipping...");
                    this.worldLatestSleepAge.remove(pWorld);
                    String chosenMessage = this.nightSkip.get(this.random.nextInt(this.nightSkip.size()));
                    for (Player players : world.getPlayers()) {
                        this.messageHandler.sendMessage(players, chosenMessage.replace("%percent%", this.dfrmt.format(percentage) + "%").replace("%count%", this.dfrmt.format(wsleeping)).replace("%count_needed%", this.dfrmt.format(countNeeded)).replace("%player%", player.getName()));
                    }
                    this.worldSleepers.get(pWorld).clear();
                    this.skipping.add(pWorld);
                    this.recentlySkipped.add(pWorld);
                    if (!this.useAnimation) {
                        this.scheduler.runDelayedTask(() -> {
                            this.messageHandler.broadcastDebug("Skipping after delay");
                            world.setTime(this.dayTime);
                            world.setStorm(false);
                            this.skipping.remove(pWorld);
                            this.scheduler.runDelayedTask(() -> {
                                this.sleepingWorlds.put(pWorld, Float.valueOf(0.0f));
                                this.recentlySkipped.remove(pWorld);
                                if (player.isOnline() && this.debugPlayers.contains(player.getUniqueId())) {
                                    this.messageHandler.sendDebug(player, "sleeping set to 0");
                                }
                            }, 20L);
                        }, 120L);
                    } else {
                        this.messageHandler.broadcastDebug("Skipping with animation");
                    }
                }
            }
        }, 1L);
    }

    public float onlinePlayers(String worldName) {
        float onlineIgnored = 0.0f;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.ignorePlayers.contains(p.getUniqueId()) && p.getWorld().getName() == worldName && !p.getGameMode().equals((Object)GameMode.SPECTATOR) && !p.getGameMode().equals((Object)GameMode.CREATIVE) && (!this.ignoreAFKPlayers || !this.isAFK(p))) continue;
            onlineIgnored += 1.0f;
        }
        float total = (float)Bukkit.getOnlinePlayers().size() - onlineIgnored;
        this.playersOnline.put(worldName, Float.valueOf(total));
        return total;
    }

    public boolean isAFK(Player player) {
        return this.essentials != null && this.essentials.getUser(player).isAfk();
    }

    public HashMap<String, Float> getPlayersOnline() {
        return this.playersOnline;
    }

    public HashMap<String, Float> getSleepingWorlds() {
        return this.sleepingWorlds;
    }

    public ArrayList<String> getRecentlySkipped() {
        return this.recentlySkipped;
    }

    public ArrayList<UUID> getWorldSleepers(String worldName) {
        return this.worldSleepers.getOrDefault(worldName, new ArrayList());
    }

    public ArrayList<Player> getOnlineIgnorers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.ignorePlayers.contains(p.getUniqueId())) continue;
            players.add(p);
        }
        return players;
    }
}

