/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import sleeper.main.Main;

public class MessageHandler {
    Main plugin;
    private Set<String> allowedTypes = Set.of("MINECRAFT", "MINIMESSAGE");
    String formattingType = "MINECRAFT";
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public MessageHandler(Main plugin) {
        this.plugin = plugin;
    }

    public Component parseMessage(String message) {
        switch (this.formattingType) {
            case "MINECRAFT": {
                return LegacyComponentSerializer.legacyAmpersand().deserialize(message);
            }
            case "MINIMESSAGE": {
                Object component = this.miniMessage.deserialize(message);
                return component;
            }
        }
        return Component.text(message);
    }

    public String parseMessageString(String message) {
        switch (this.formattingType) {
            case "MINECRAFT": {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            }
            case "MINIMESSAGE": {
                Object component = this.miniMessage.deserialize(message);
                return LegacyComponentSerializer.legacySection().serialize((Component)component);
            }
        }
        return message;
    }

    public void sendMessage(Player player, String message) {
        if (message.equals("")) {
            return;
        }
        if (this.plugin.actionbarMessages) {
            this.sendActionbarMessage(player, message);
        } else {
            Audience audience = this.plugin.adventure().player(player);
            audience.sendMessage(this.parseMessage(message));
        }
    }

    public void sendMessageUnparsed(Player player, String message) {
        if (message.equals("")) {
            return;
        }
        if (this.plugin.actionbarMessages) {
            this.sendActionbarMessage(player, message);
        } else {
            player.sendMessage(message);
        }
    }

    public void sendActionbarMessage(Player player, String message) {
        Audience audience = this.plugin.adventure().player(player);
        audience.sendActionBar(this.parseMessage(message));
    }

    public void broadcastDebug(String message) {
        for (UUID debugUUID : this.plugin.debugPlayers) {
            Player player = Bukkit.getPlayer((UUID)debugUUID);
            if (!player.isOnline()) continue;
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + message);
        }
    }

    public void sendDebug(Player player, String message) {
        if (!this.plugin.debugPlayers.contains(player.getUniqueId())) {
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + message);
    }

    public void loadConfig(FileConfiguration config) {
        String configFormattingType = config.getString("FormattingType");
        if (configFormattingType != null && this.allowedTypes.contains(configFormattingType.toUpperCase())) {
            this.formattingType = configFormattingType.toUpperCase();
        } else {
            this.plugin.getLogger().warning("FormattingType value is not appropriate! Reset to default.");
        }
    }
}

