/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import sleeper.main.Main;

public class Scheduler {
    Main plugin;
    private boolean isFolia = false;

    public Scheduler(Main plugin) {
        this.plugin = plugin;
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            this.isFolia = true;
        }
        catch (ClassNotFoundException e) {
            this.isFolia = false;
        }
    }

    public void runRepeatingTask(@NotNull Runnable task, long delay, long period) {
        if (this.isFolia) {
            Bukkit.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> task.run(), delay, period);
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, task, delay, period);
        }
    }

    public void runDelayedTask(@NotNull Runnable task, long delay) {
        if (this.isFolia) {
            Bukkit.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> task.run(), delay);
        } else {
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.plugin, task, delay);
        }
    }

    public void runAsyncTask(@NotNull Runnable task) {
        if (this.isFolia) {
            Bukkit.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> task.run());
        } else {
            Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        }
    }
}

