/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import sleeper.main.Main;
import sleeper.main.MessageHandler;

public class Voting {
    Main plugin;
    MessageHandler messageHandler;
    DecimalFormat dfrmt = new DecimalFormat();
    ArrayList<String> votingWorlds = new ArrayList();
    HashMap<String, Integer> votingWorldTimes = new HashMap();
    HashMap<String, String> yesVotes = new HashMap();
    HashMap<String, String> noVotes = new HashMap();
    private int tickCounter = 0;
    boolean useVote = false;
    int yesMultiplier = 1;
    int noMultiplier = 1;
    int skipVotePercent = 50;
    public boolean blockBedsAfterVoting = false;
    boolean bossbarVoteCount = true;
    boolean actionVoteCount = true;
    boolean sendVotesOnStart = true;
    boolean voteStarts = false;
    int maxVoteTime = 60;
    boolean limitedVoteTime = false;
    String voteTitle = "&aSleep > &7Vote below on skipping the night:";
    String voteYes = "&a&lYes";
    String voteNo = "&c&lNo";
    String votedYes = "&aYou voted to skip the night.";
    String votedNo = "&aYou voted not to skip the night.";
    String noVote = "&cYour world isn't voting on a night skip.";
    String alreadyYes = "&cYou have already voted yes.";
    String alreadyNo = "&cYou have already voted no.";
    String listVotes = "&aYes: &7%yes% &cNo: &7%no%";
    String skipByVote = "&aSleep > &7The vote has decided to skip the night!";
    String voteNotEnabled = "&cVoting is not enabled.";
    String voteTimedOut = "&aSleep > &cThe vote ended without skipping the night.";

    public Voting(Main plugin, MessageHandler messageFormatting) {
        this.plugin = plugin;
        this.messageHandler = messageFormatting;
        this.dfrmt.setMaximumFractionDigits(2);
    }

    public void startVote(Player player) {
        World world = player.getWorld();
        String pWorld = world.getName();
        this.plugin.onlinePlayers(pWorld);
        if (!this.votingWorlds.contains(pWorld) && world.getTime() >= this.plugin.nightTime) {
            this.votingWorlds.add(pWorld);
            if (this.limitedVoteTime) {
                this.votingWorldTimes.put(pWorld, this.maxVoteTime * 20);
            }
            if (this.sendVotesOnStart) {
                world.getPlayers().forEach(wPlayer -> this.sendVoteMsg((Player)wPlayer));
            }
        } else if (world.getTime() >= this.plugin.nightTime) {
            this.sendVoteMsg(player);
        }
    }

    public void voteYes(Player player) {
        if (!player.hasPermission("sleeper.vote")) {
            this.messageHandler.sendMessage(player, this.plugin.noPermission);
            return;
        }
        if (!this.useVote) {
            this.messageHandler.sendMessage(player, this.voteNotEnabled);
            return;
        }
        if (this.voteStarts && !this.votingWorlds.contains(player.getWorld().getName())) {
            this.startVote(player);
        }
        if (!this.votingWorlds.contains(player.getWorld().getName())) {
            this.messageHandler.sendMessage(player, this.noVote);
            return;
        }
        if (this.yesVotes.containsKey(player.getName())) {
            this.messageHandler.sendMessage(player, this.alreadyYes);
            return;
        }
        this.noVotes.remove(player.getName());
        this.yesVotes.put(player.getName(), player.getWorld().getName());
        this.messageHandler.sendMessage(player, this.votedYes);
        this.plugin.onlinePlayers(player.getWorld().getName());
        this.showVotes(player);
    }

    public void voteNo(Player player) {
        if (!player.hasPermission("sleeper.vote")) {
            this.messageHandler.sendMessage(player, this.plugin.noPermission);
            return;
        }
        if (!this.useVote) {
            this.messageHandler.sendMessage(player, this.voteNotEnabled);
            return;
        }
        if (this.voteStarts && !this.votingWorlds.contains(player.getWorld().getName())) {
            this.startVote(player);
        }
        if (!this.votingWorlds.contains(player.getWorld().getName())) {
            this.messageHandler.sendMessage(player, this.noVote);
            return;
        }
        if (this.noVotes.containsKey(player.getName())) {
            this.messageHandler.sendMessage(player, this.alreadyNo);
            return;
        }
        this.yesVotes.remove(player.getName());
        this.noVotes.put(player.getName(), player.getWorld().getName());
        this.messageHandler.sendMessage(player, this.votedNo);
        this.plugin.onlinePlayers(player.getWorld().getName());
        this.showVotes(player);
    }

    public int countYes(String worldName) {
        int yVotes = 0;
        for (Map.Entry<String, String> set : this.yesVotes.entrySet()) {
            if (!set.getValue().equals(worldName)) continue;
            ++yVotes;
        }
        return yVotes;
    }

    public int countNo(String worldName) {
        int nVotes = 0;
        for (Map.Entry<String, String> set : this.noVotes.entrySet()) {
            if (!set.getValue().equals(worldName)) continue;
            ++nVotes;
        }
        return nVotes;
    }

    public void sendVoteMsg(Player player) {
        if (!this.useVote) {
            this.messageHandler.sendMessage(player, this.voteNotEnabled);
            return;
        }
        Audience audience = this.plugin.adventure().player(player);
        audience.sendMessage(this.messageHandler.parseMessage(this.voteTitle));
        Component yesMessage = this.messageHandler.parseMessage(this.voteYes).clickEvent(ClickEvent.runCommand("/sleep yes"));
        audience.sendMessage(yesMessage);
        Component noMessage = this.messageHandler.parseMessage(this.voteNo).clickEvent(ClickEvent.runCommand("/sleep no"));
        audience.sendMessage(noMessage);
    }

    public void showVotes(Player player) {
        this.messageHandler.sendMessage(player, this.listVotes.replace("%yes%", this.dfrmt.format(this.countYes(player.getWorld().getName()))).replace("%no%", this.dfrmt.format(this.countNo(player.getWorld().getName()))));
    }

    public boolean hasVoted(Player player) {
        return this.yesVotes.containsKey(player.getName()) || this.noVotes.containsKey(player.getName());
    }

    public void endVote(String worldName) {
        this.votingWorlds.remove(worldName);
        this.plugin.bar.removeAll();
        ArrayList<String> removeVotes = new ArrayList<String>();
        for (Map.Entry<String, String> vote : this.yesVotes.entrySet()) {
            if (!vote.getValue().equals(worldName)) continue;
            removeVotes.add(vote.getKey());
        }
        removeVotes.forEach(name -> this.yesVotes.remove(name));
        removeVotes.clear();
        for (Map.Entry<String, String> vote : this.noVotes.entrySet()) {
            if (!vote.getValue().equals(worldName)) continue;
            removeVotes.add(vote.getKey());
        }
        removeVotes.forEach(name -> this.noVotes.remove(name));
        removeVotes.clear();
    }

    public void tick() {
        for (String worldName : new ArrayList<String>(this.votingWorlds)) {
            float skipMargin;
            int nVotes;
            World world = Bukkit.getWorld((String)worldName);
            long time = world.getTime();
            if (this.plugin.skipping.contains(worldName)) continue;
            if (this.bossbarVoteCount) {
                this.plugin.bar.setTitle(this.messageHandler.parseMessageString(this.listVotes.replace("%yes%", this.dfrmt.format(this.countYes(worldName))).replace("%no%", this.dfrmt.format(this.countNo(worldName)))));
                for (Player player2 : world.getPlayers()) {
                    if (this.plugin.bar.getPlayers().contains(player2)) continue;
                    this.plugin.bar.addPlayer(player2);
                }
            }
            if (this.actionVoteCount) {
                ++this.tickCounter;
                if (this.tickCounter % 20 != 0) {
                    return;
                }
                for (Player player2 : world.getPlayers()) {
                    this.messageHandler.sendActionbarMessage(player2, this.listVotes.replace("%yes%", this.dfrmt.format(this.countYes(worldName))).replace("%no%", this.dfrmt.format(this.countNo(worldName))));
                }
            }
            if (this.votingWorldTimes.containsKey(worldName)) {
                int timeLeft = this.votingWorldTimes.get(worldName) - 1;
                if (timeLeft <= 0) {
                    this.votingWorldTimes.remove(worldName);
                    world.getPlayers().forEach(player -> this.messageHandler.sendMessage((Player)player, this.voteTimedOut));
                    this.endVote(worldName);
                }
                this.votingWorldTimes.replace(worldName, timeLeft);
            }
            if (time < this.plugin.dayTime + 2000L && time >= this.plugin.dayTime) {
                this.endVote(worldName);
                continue;
            }
            int yVotes = this.countYes(worldName);
            float skipFactor = (float)(yVotes * this.yesMultiplier - (nVotes = this.countNo(worldName)) * this.noMultiplier) / this.plugin.playersOnline.get(worldName).floatValue();
            if (!(skipFactor >= (skipMargin = (float)this.skipVotePercent * 0.01f))) continue;
            this.plugin.skipping.add(worldName);
            this.plugin.recentlySkipped.add(worldName);
            world.getPlayers().forEach(player -> this.messageHandler.sendMessage((Player)player, this.skipByVote));
            this.plugin.getLogger().info("Skipping night by vote in " + worldName);
        }
    }

    public void loadConfig(FileConfiguration config) {
        this.useVote = config.getBoolean("VoteSkip");
        this.yesMultiplier = config.getInt("YesMultiplier");
        this.noMultiplier = config.getInt("NoMultiplier");
        this.skipVotePercent = config.getInt("SkipVotePercent");
        this.voteTitle = config.getString("VoteTitle");
        this.voteYes = config.getString("VoteYes");
        this.voteNo = config.getString("VoteNo");
        this.votedYes = config.getString("VotedYes");
        this.votedNo = config.getString("VotedNo");
        this.noVote = config.getString("NoVote");
        this.alreadyYes = config.getString("AlreadyYes");
        this.alreadyNo = config.getString("AlreadyNo");
        this.listVotes = config.getString("ListVotes");
        this.skipByVote = config.getString("SkipByVote");
        this.voteNotEnabled = config.getString("VoteNotEnabled");
        this.blockBedsAfterVoting = config.getBoolean("BlockBedsAfterVoting");
        this.bossbarVoteCount = config.getBoolean("BossbarVoteCount");
        this.actionVoteCount = config.getBoolean("ActionbarVoteCount");
        this.sendVotesOnStart = config.getBoolean("SendVotesOnStart");
        this.voteStarts = config.getBoolean("StartWithoutSleep");
        this.maxVoteTime = config.getInt("MaxVoteTime");
        this.limitedVoteTime = config.getBoolean("LimitedVoteTime");
        this.voteTimedOut = config.getString("VoteTimedOut");
    }

    public ArrayList<String> getVotingWorlds() {
        return this.votingWorlds;
    }
}

