package net.trique.wardentools.advancements.criterion;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1297;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.trique.wardentools.registry.TriggerTypeRegistry;

import java.util.Optional;
import java.util.Set;

public class AffectedEntitiesTrigger extends class_4558<AffectedEntitiesTrigger.TriggerInstance> {

    @Override
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1799 handheld, Set<class_1297> entities) {
        this.method_22510(player, triggerInstance -> triggerInstance.matches(handheld, entities.size()));
    }

    public record TriggerInstance(Optional<class_5258> player, class_2073 weapon, class_2096.class_2100 count) implements class_4558.class_8788 {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                        class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029),
                        class_2073.field_45754.fieldOf("weapon").forGetter(TriggerInstance::weapon),
                        class_2096.class_2100.field_45763.optionalFieldOf("count", class_2096.class_2100.field_9708).forGetter(TriggerInstance::count)
                ).apply(instance, TriggerInstance::new)
        );

        public TriggerInstance(class_2073 item, Optional<class_5258> player) {
            this(player, item, class_2096.class_2100.field_9708);
        }

        public static class_175<TriggerInstance> create(class_2073.class_2074 item, class_2096.class_2100 count) {
            return TriggerTypeRegistry.AFFECTED_ENTITIES_TRIGGER.get().method_53699(new TriggerInstance(Optional.empty(), item.method_8976(), count));
        }

        public static class_175<TriggerInstance> exactCount(class_2073.class_2074 item, int count) {
            return create(item, class_2096.class_2100.method_9058(count));
        }

        public static class_175<TriggerInstance> range(class_2073.class_2074 item, int min, int max) {
            return create(item, class_2096.class_2100.method_35287(min, max));
        }

        public static class_175<TriggerInstance> minCount(class_2073.class_2074 item, int min) {
            return create(item, class_2096.class_2100.method_9053(min));
        }

        public static class_175<TriggerInstance> maxCount(class_2073.class_2074 item, int max) {
            return create(item, class_2096.class_2100.method_35289(max));
        }

        public boolean matches(class_1799 stack, int entityCount) {
            return this.weapon.method_8970(stack) && this.count.method_9054(entityCount);
        }

    }
}
