package net.trique.wardentools.effect_armor_set;

import me.cybersteve.equiplib.armorset.base.EffectArmorSet;
import me.cybersteve.equiplib.armorset.impl.FullEffectArmorSet;
import me.cybersteve.equiplib.item.armor.base.IEffectArmorItem;
import me.cybersteve.equiplib.util.ArmorSetHelper;
import me.cybersteve.equiplib.util.EffectList;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.trique.wardentools.registry.EffectRegistry;
import net.trique.wardentools.registry.ItemRegistry;

import java.util.List;

import static net.trique.wardentools.util.ModHelper.getLoc;

public class WardenSet extends EffectArmorSet {

    public WardenSet() {
        super(getLoc("warden_set"));
    }

    @Override
    public EffectList getEffectsWhenWearing(class_1309 entity) {
        EffectList.Builder builder = new EffectList.Builder();
        if (!entity.method_6118(class_1304.field_6169).method_31574(ItemRegistry.WARDEN_MASK.get())) {
            if (ArmorSetHelper.hasFullEffectSetArmorOn(entity, this)) {
                builder = builder.addInfiniteEffect(EffectRegistry.SCULK_ADAPTION, 0, true, false, true)
                        .addInfiniteEffect(class_1294.field_5918, 0, true, false, true)
                        .addInfiniteEffect(class_1294.field_5910, 3, true, false, true)
                        .addInfiniteEffect(class_1294.field_5914, 4, true, false, true);
            }
        } else {
            int wardenCurseAmpl = 0;
            for (class_1304 slot : List.of(class_1304.field_6174, class_1304.field_6172, class_1304.field_6166)) {
                if (entity.method_6118(slot).method_7909() instanceof IEffectArmorItem effectArmorItem &&
                        effectArmorItem.getEffectArmorSet().equals(this)) {
                    wardenCurseAmpl++;
                }
            }
            builder = builder.addInfiniteEffect(EffectRegistry.WARDEN_CURSE, wardenCurseAmpl, true, false, true);
            if (ArmorSetHelper.hasFullEffectSetArmorOn(entity, this)) {
                builder = builder.addInfiniteEffect(EffectRegistry.SCULK_ADAPTION, 0, true, false, true)
                        .addInfiniteEffect(class_1294.field_5918, 0, true, false, true)
                        .addInfiniteEffect(class_1294.field_5910, 9, true, false, true)
                        .addInfiniteEffect(class_1294.field_5914, 14, true, false, true);
            }
        }
        return builder.build();
    }
}
