package net.trique.wardentools.entity;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3483;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_9109;
import net.minecraft.world.phys.*;
import net.trique.wardentools.Constants;
import net.trique.wardentools.registry.EntityRegistry;
import net.trique.wardentools.registry.ItemRegistry;
import net.trique.wardentools.registry.TriggerTypeRegistry;

import java.util.HashSet;
import java.util.Set;

public class SculkArrowEntity extends class_1667 {
    private double base_radius = 4;
    private int life = 0;
    private boolean hit = false;

    public SculkArrowEntity(class_1299<? extends class_1667> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SculkArrowEntity(class_1937 world, class_1309 owner) {
        super(EntityRegistry.SCULK_ARROW.get(), world);
        this.method_7432(owner);
        if (owner.method_6047().method_31574(ItemRegistry.ECHO_LOCATOR.get())) {
            this.method_5875(true);
            double multiplier = 3;
            base_radius *= multiplier;
        }
        this.method_5814(owner.method_23317(), owner.method_23320() - 0.1, owner.method_23321());
    }

    @Override
    public void method_5773() {
        super.method_5773();
        ++life;
        if (life >= 1200 && !hit) method_31472();
    }

    @Override
    protected class_1799 method_7445() {
        return new class_1799(ItemRegistry.SCULK_ARROW.get());
    }

    @Override
    protected class_1799 method_57314() {
        return new class_1799(ItemRegistry.SCULK_ARROW.get());
    }

    @Override
    protected void method_7450(class_1309 target) {
        super.method_7450(target);
        target.method_6092(new class_1293(class_1294.field_38092, 100, 0));
        target.method_6092(new class_1293(class_1294.field_5909, 60, 1));
        this.method_37908().method_8396(null, target.method_24515(),
                class_3417.field_38830, class_3419.field_15248,
                1.0F, 1.0F);
    }

    @Override
    protected void method_7488(class_239 result) {
        class_239.class_240 hitresult$type = result.method_17783();
        Set<class_1297> victims = new HashSet<>();

        if (hitresult$type == class_239.class_240.field_1331) {
            class_3966 entityhitresult = (class_3966) result;
            class_1297 hit_entity = entityhitresult.method_17782();
            if (hit_entity.method_5864().method_20210(class_3483.field_51503) && hit_entity instanceof class_1676 projectile) {
                projectile.method_59859(class_9109.field_51509, this.method_24921(), this.method_24921(), true);
            } else if (hit_entity instanceof class_1309 victim) {
                hit = true;
//                Vec3 hit_location = entityhitresult.getLocation();
//                shriek(hit_location.add(0.0, victim.getBbHeight() + 0.3, 0.0));
                victims.addAll(this.method_37908().method_18467(class_1309.class, new class_238(new class_2338((int) victim.method_23317(),
                        (int) victim.method_23318(), (int) victim.method_23321())).method_1014(base_radius)));
                victims.remove(this.method_24921());
                victims.forEach(entity -> {
                    if (entity instanceof class_1309 living)
                        living.method_6092(new class_1293(class_1294.field_5912, 100));
                });
            }
            this.method_7454(entityhitresult);
            this.method_37908().method_32888(class_5712.field_28162, result.method_17784(), class_5712.class_7397.method_43286(this, (class_2680) null));
            this.method_37908().method_43128(null, hit_entity.method_23317(), hit_entity.method_23318(), hit_entity.method_23321(), class_3417.field_38060, this.method_5634(), 2.0f, 0.6f + this.method_37908().method_8409().method_43057() * 0.4f);

        } else if (hitresult$type == class_239.class_240.field_1332) {
            hit = true;
            class_3965 blockhitresult = (class_3965) result;
            this.method_24920(blockhitresult);
//            shriek(blockhitresult.getLocation());
            class_2338 blockpos = blockhitresult.method_17777();
            this.method_37908().method_43276(class_5712.field_28162, blockpos, class_5712.class_7397.method_43286(this, this.method_37908().method_8320(blockpos)));
            victims.addAll(this.method_37908().method_18467(class_1309.class, new class_238(new class_2338(blockpos.method_10263(),
                    blockpos.method_10264(), blockpos.method_10260())).method_1014(base_radius)));
            victims.remove(this.method_24921());
            victims.forEach(entity -> {
                if (entity instanceof class_1309 living)
                    living.method_6092(new class_1293(class_1294.field_5912, 100));
            });
            this.method_37908().method_43128(null, blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260(), class_3417.field_38060, this.method_5634(), 2.0f, 0.6f + this.method_37908().method_8409().method_43057() * 0.4f);


        }
        if (this.method_24921() instanceof class_3222 player) {
            TriggerTypeRegistry.AFFECTED_ENTITIES_TRIGGER.get().trigger(player, this.method_7445(), victims);
        }
    }

//    protected void shriek(Vec3 pos) {
//        if (this.level() instanceof ServerLevel level) {
//            BlockPos containingPos = BlockPos.containing(pos.x, pos.y, pos.z);
//            for(int i = 0; i < 10; ++i) {
//                level.sendParticles(new ShriekParticleOption(i * 5), pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
//            }
//            BlockState blockState = level.getBlockState(containingPos);
//            boolean flag = blockState.hasProperty(BlockStateProperties.WATERLOGGED) && blockState.getValue(BlockStateProperties.WATERLOGGED);
//            if (!flag) {
//                level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.SCULK_SHRIEKER_SHRIEK, this.getSoundSource(), 2.0f, 0.6f + level.getRandom().nextFloat() * 0.4f);
//            }
//        }
//    }
}