package net.trique.wardentools.item.archery;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.trique.wardentools.item.util.ISonicBoomItem;
import net.trique.wardentools.particle.echo_particle.EchoParticleOption;
import net.trique.wardentools.registry.ItemRegistry;
import net.trique.wardentools.registry.TriggerTypeRegistry;

import java.util.HashSet;
import java.util.Set;

public class EchoShriekerItem extends class_1753 implements ISonicBoomItem {
    private final float DEFAULT_DISTANCE = 20f;

    public EchoShriekerItem(class_1793 settings) {
        super(settings.method_57348(createAttributeModifiers()));
    }

    public static class_9285 createAttributeModifiers() {
        return class_9285.method_57480()
                .method_57487(class_5134.field_23721, new class_1322(field_8006, 3.0f, class_1322.class_1323.field_6328), class_9274.field_49217)
                .method_57487(class_5134.field_23723, new class_1322(field_8001, 0f, class_1322.class_1323.field_6328), class_9274.field_49217)
                .method_57486();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        boolean bl = !findEchoShard(user).method_7960();
        if (!user.method_56992() && !bl) {
            return class_1271.method_22431(itemStack);
        } else {
            user.method_6019(hand);
            world.method_43128(user, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_38831, user.method_5634(), 3.0f, 1.0f);
            return class_1271.method_22428(itemStack);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (world instanceof class_3218 serverLevel && user instanceof class_1657 player) {
            int i = this.method_7881(stack, user) - remainingUseTicks;
            float loadAmount = method_7722(i);
            class_1799 ammo = findEchoShard(player);
            if (!((double) loadAmount < 0.1f)) {
                spawnSonicBoom(stack, serverLevel, user, loadAmount);
                if (!player.method_7337()) {
                    player.method_7357().method_7906(this, 120);
                    stack.method_7970(1, user, class_1304.field_6173);
                    ammo.method_7934(1);
                }
                player.method_7259(class_3468.field_15372.method_14956(this));
            }
        }
    }

    protected class_1799 findEchoShard(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_31574(class_1802.field_38746)) {
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(ItemRegistry.SHRIEKER_FANG.get());
    }

    private void spawnSonicBoom(class_1799 stack, class_3218 world, class_1309 user, float remainTicks) {
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_38060, user.method_5634(), 5.0f, 1.0f);
        class_243 source = user.method_19538().method_1031(0.0, user.method_5751(), 0.0);
        float enhanced_distance = calculateFinalDistance(stack, world, DEFAULT_DISTANCE) * remainTicks * remainTicks;
        class_243 target = source.method_1019(user.method_5720().method_1021(enhanced_distance));
        class_243 offsetToTarget = target.method_1020(source);
        class_243 normalized = offsetToTarget.method_1029();
        Set<class_1297> hit = new HashSet<>();
        class_238 cube = new class_238(new class_2338((int) source.method_10216(),
                (int) source.method_10214(), (int) source.method_10215())).method_1014(enhanced_distance);
        hit.addAll(world.method_8390(class_1309.class, cube, it -> isAABBInConeSimple(source, offsetToTarget, it.method_5829()) && !((it.method_5722(user)) || (it instanceof class_1321 helper && helper.method_6171(user)))));
        for (float particleScale = 1; particleScale <= offsetToTarget.method_1033(); particleScale++) {
            class_243 particlePos = source.method_1019(normalized.method_1021(particleScale));
            world.method_14199(new EchoParticleOption(particleScale * 1.4f, user.method_36455(), user.method_36454()), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350,
                    1, 0, 0, 0, 0);
        }

        hit.remove(user);

        for (class_1297 hitTarget : hit) {
            float distanceToTarget = user.method_5739(hitTarget);
            float baseDamage = calculateBaseDamage(remainTicks, distanceToTarget);
            class_1282 damageSource = world.method_48963().method_48821(user);
            float enchantedDamage = calculateEnchantedDamage(world, stack, hitTarget, damageSource, baseDamage);
            hitTarget.method_5643(damageSource, enchantedDamage);
            if (hitTarget instanceof class_1309 living) {
                living.method_6092(new class_1293(class_1294.field_5912, 100));
                living.method_6092(new class_1293(class_1294.field_5909, 100, 2));
                living.method_6092(new class_1293(class_1294.field_5911, 160, 2));
                living.method_6092(new class_1293(class_1294.field_5919, 60));
                double vertical = 0.5 * (1.0 - living.method_45325(class_5134.field_23718));
                double horizontal = 2.5 * (1.0 - living.method_45325(class_5134.field_23718));
                living.method_5762(normalized.method_10216() * horizontal, normalized.method_10214() * vertical, normalized.method_10215() * horizontal);
            }
        }
        if (user instanceof class_3222 player) {
            TriggerTypeRegistry.AFFECTED_ENTITIES_TRIGGER.get().trigger(player, stack, hit);
        }
    }

    public static boolean isAABBInConeSimple(class_243 vertex, class_243 axisVector, class_238 aabb) {
        float angleDegrees = (float) Math.toRadians(15);
        float axisLength = (float) axisVector.method_1033();
        if (axisLength == 0) return false;
        class_243 axisUnit = axisVector.method_1029();
        float tanAngle = (float) Math.tan(angleDegrees);

        // Checking center of AABB
        class_243 center = aabb.method_1005();

        class_243 toCenter = center.method_1020(vertex);
        float centerHeight = (float) toCenter.method_1026(axisUnit);

        // if the center is outside "cone heights"
        if (centerHeight < 0 || centerHeight > axisLength) {
            return false;
        }

        // Checking distance between center and axis
        class_243 projection = axisUnit.method_1021(centerHeight);
        class_243 perpendicular = toCenter.method_1020(projection);
        float distanceToAxis = (float) perpendicular.method_1033();

        // Check if center inside the cone
        if (distanceToAxis <= centerHeight * tanAngle) {
            return true;
        }

        // If center isn't in the cone, checking closest point of the AABB to the cone
        class_243 closestPoint = getClosestPointOnAABB(aabb, vertex, axisUnit, centerHeight);
        class_243 toClosest = closestPoint.method_1020(vertex);
        double closestHeight = toClosest.method_1026(axisUnit);

        if (closestHeight < 0 || closestHeight > axisLength) {
            return false;
        }

        class_243 closestProjection = axisUnit.method_1021(closestHeight);
        class_243 closestPerpendicular = toClosest.method_1020(closestProjection);
        double closestDistance = closestPerpendicular.method_1033();

        return closestDistance <= closestHeight * tanAngle;
    }

    private static class_243 getClosestPointOnAABB(class_238 aabb, class_243 vertex, class_243 axisUnit,
                                              double centerHeight) {

        class_243 pointOnAxis = vertex.method_1019(axisUnit.method_1021(centerHeight));
        double closestX = Math.max(aabb.field_1323, Math.min(pointOnAxis.field_1352, aabb.field_1320));
        double closestY = Math.max(aabb.field_1322, Math.min(pointOnAxis.field_1351, aabb.field_1325));
        double closestZ = Math.max(aabb.field_1321, Math.min(pointOnAxis.field_1350, aabb.field_1324));

        return new class_243(closestX, closestY, closestZ);
    }

    private float calculateBaseDamage(float chargingAmount, float distanceToTarget) {
        float baseDamage = 40f; // base damage
        float amplifier = 2f; // multiplier for close-range
        float maxMinDamage = baseDamage / 3; // minimum possible damage after falloff (but without charging amount
        float damage = baseDamage;
        float falloff_multiplier = (baseDamage - maxMinDamage) / (DEFAULT_DISTANCE-2); // damage falloff per block
        if (Math.floor(distanceToTarget) >= 2) {
            damage -= (distanceToTarget - 2) * falloff_multiplier;
            if (damage < maxMinDamage) damage = maxMinDamage;
        } else {
            damage *= amplifier;
        }
        return damage * chargingAmount;
    }
}
