package net.trique.wardentools.item.armor;

import me.cybersteve.equiplib.armorset.base.EffectArmorSet;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import net.minecraft.class_6880;
import net.trique.wardentools.client.renderer.WardenMaskRenderer;
import net.trique.wardentools.platform.Services;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.function.Consumer;

public class WardenMaskItem extends WardenArmorItem implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    private static final RawAnimation TENDRILS_CLICK = RawAnimation.begin().thenPlay("mask.tendrils.click");

    public WardenMaskItem(class_6880<class_1741> material, class_8051 type, class_1793 settings, EffectArmorSet set) {
        super(material, type, settings, set);
        SingletonGeoAnimatable.registerSyncedAnimatable(this);
    }

    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider() {
            private WardenMaskRenderer renderer;

            @Override
            public <T extends class_1309> class_572<?> getGeoArmorRenderer(@Nullable T livingEntity, class_1799 itemStack, @Nullable class_1304 equipmentSlot, @Nullable class_572<T> original) {
                if (this.renderer == null)
                    this.renderer = new WardenMaskRenderer();
                // Defer creation of our renderer then cache it so that it doesn't get instantiated too early

                return this.renderer;
            }
        });
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<GeoAnimatable>(this,
                "warden_mask",
                state -> {
                    if (Services.PLATFORM.isDevelopmentEnvironment()) {
                        RawAnimation tendrilsClick_looping = RawAnimation.begin().thenLoop("mask.tendrils.click");
                        class_1297 entity = state.getData(DataTickets.ENTITY);
                        // We'll just have ArmorStands always animate, so we can return here
                        if (entity instanceof class_1531 || !(entity instanceof class_1309))
                            return state.setAndContinue(tendrilsClick_looping);
                    }
                    return PlayState.STOP;
                })
                .triggerableAnim("tendrils_click", TENDRILS_CLICK));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }
}
