package net.trique.wardentools.item.material;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1738.class_8051;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.trique.wardentools.Constants;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;
import net.trique.wardentools.registry.ItemRegistry;

public class WardenArmorMaterials {
    protected static final RegistrationProvider<class_1741> ARMOR_MATERIALS = RegistrationProvider.get(class_7924.field_48977, Constants.MOD_ID);
    private static final class_6880<class_3414> SONIC_BOOM_SOUND = class_6880.method_40223(class_3417.field_38830);

    public static void init() {
        Constants.LOGGER.info("Registering armor materials for Warden Tools...");
    }

    private static class_6880<class_1741> registerMaterial(String id, Map<class_8051, Integer> defensePoints, int enchantability, class_6880<class_3414> equipSound, Supplier<class_1856> repairIngredientSupplier, float toughness, float knockbackResistance, boolean dyeable) {
        List<class_1741.class_9196> layers = List.of(
                new class_1741.class_9196(class_2960.method_60655(Constants.MOD_ID, id), "", dyeable)
        );
        RegistryObject<class_1741, class_1741> materialRegistryObject = ARMOR_MATERIALS.register(id,
                () -> new class_1741(defensePoints, enchantability, equipSound, repairIngredientSupplier, layers, toughness, knockbackResistance));
        return materialRegistryObject.asHolder();
    }

    public static final class_6880<class_1741> SCULKIFIED = registerMaterial("sculkified", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
                map.put(class_8051.field_41937, 3);
                map.put(class_8051.field_41936, 6);
                map.put(class_8051.field_41935, 8);
                map.put(class_8051.field_41934, 3);
            }), 18, class_3417.field_15103,
            () -> class_1856.method_8091(ItemRegistry.ECHO_INGOT.get()), 2.5f, 0.05f, false);

    public static final class_6880<class_1741> WARDEN = registerMaterial("warden", class_156.method_654(new EnumMap<>(class_8051.class), map -> {
                map.put(class_8051.field_41937, 5);
                map.put(class_8051.field_41936, 8);
                map.put(class_8051.field_41935, 10);
                map.put(class_8051.field_41934, 5);
            }), 21, SONIC_BOOM_SOUND,
            () -> class_1856.method_8091(ItemRegistry.WARDEN_INGOT.get()), 5.0f, 0.15f, false);

}