package net.trique.wardentools.item.material;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.trique.wardentools.registry.ItemRegistry;
import net.trique.wardentools.util.WTBlockTags;

public enum WardenToolMaterials implements class_1832 {
    SCULKIFIED(WTBlockTags.INCORRECT_FOR_SCULKHYST_TOOLS, 1796, 8.5f, 3.5f, 12, () -> class_1856.method_8091(ItemRegistry.ECHO_INGOT.get())),
    WARDEN(WTBlockTags.INCORRECT_FOR_WARDEN_TOOLS, 3001, 11.0f, 6.0f, 21, () -> class_1856.method_8091(ItemRegistry.WARDEN_INGOT.get()));

    private final class_6862<class_2248> inverseTag;
    private final int itemDurability;
    private final float miningSpeed;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<class_1856> repairIngredient;

    WardenToolMaterials(final class_6862<class_2248> inverseTag, int itemDurability, float miningSpeed, float attackDamage, int enchantability, Supplier<class_1856> repairIngredient) {
        this.inverseTag = inverseTag;
        this.itemDurability = itemDurability;
        this.miningSpeed = miningSpeed;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    @Override
    public int method_8025() {
        return this.itemDurability;
    }

    @Override
    public float method_8027() {
        return this.miningSpeed;
    }

    @Override
    public float method_8028() {
        return this.attackDamage;
    }

    @Override
    public class_6862<class_2248> method_58419() {
        return this.inverseTag;
    }

    @Override
    public int method_8026() {
        return this.enchantability;
    }

    @Override
    public class_1856 method_8023() {
        return this.repairIngredient.get();
    }
}