package net.trique.wardentools.item.misc;


import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8052;

public class WardenTemplateItem extends class_8052 {
    private static final class_124 TITLE_FORMATTING;
    private static final class_124 DESCRIPTION_FORMATTING;
    private static final class_2561 WARDEN_UPGRADE_TEXT;
    private static final class_2561 WARDEN_UPGRADE_APPLIES_TO_TEXT;
    private static final class_2561 WARDEN_UPGRADE_INGREDIENTS_TEXT;
    private static final class_2561 WARDEN_UPGRADE_BASE_SLOT_DESCRIPTION_TEXT;
    private static final class_2561 WARDEN_UPGRADE_ADDITIONS_SLOT_DESCRIPTION_TEXT;

    public WardenTemplateItem(class_2561 appliesToText, class_2561 ingredientsText, class_2561 titleText, class_2561 baseSlotDescriptionText, class_2561 additionsSlotDescriptionText, List<class_2960> emptyBaseSlotTextures, List<class_2960> emptyAdditionsSlotTextures) {
        super(appliesToText, ingredientsText, titleText, baseSlotDescriptionText, additionsSlotDescriptionText, emptyBaseSlotTextures, emptyAdditionsSlotTextures);
    }

    public static WardenTemplateItem createWardenUpgrade() {
        return new WardenTemplateItem(WARDEN_UPGRADE_APPLIES_TO_TEXT, WARDEN_UPGRADE_INGREDIENTS_TEXT, WARDEN_UPGRADE_TEXT, WARDEN_UPGRADE_BASE_SLOT_DESCRIPTION_TEXT, WARDEN_UPGRADE_ADDITIONS_SLOT_DESCRIPTION_TEXT, getWardenUpgradeEmptyBaseSlotTextures(), getWardenUpgradeEmptyAdditionsSlotTextures());
    }

    private static List<class_2960> getWardenUpgradeEmptyBaseSlotTextures() {
        return List.of(field_41988, field_41958, field_41989, field_41960,
                field_41990, field_41993, field_41991, field_41992, field_41959);
    }

    private static List<class_2960> getWardenUpgradeEmptyAdditionsSlotTextures() {
        return List.of(field_41961);
    }

    static {
        TITLE_FORMATTING = class_124.field_1080;
        DESCRIPTION_FORMATTING = class_124.field_1078;
        WARDEN_UPGRADE_TEXT = class_2561.method_43471(class_156.method_646("upgrade", class_2960.method_60654("warden_upgrade"))).method_27692(TITLE_FORMATTING);
        WARDEN_UPGRADE_APPLIES_TO_TEXT = class_2561.method_43471(class_156.method_646("item", class_2960.method_60654("smithing_template.warden_upgrade.applies_to"))).method_27692(DESCRIPTION_FORMATTING);
        WARDEN_UPGRADE_INGREDIENTS_TEXT = class_2561.method_43471(class_156.method_646("item", class_2960.method_60654("smithing_template.warden_upgrade.ingredients"))).method_27692(DESCRIPTION_FORMATTING);
        WARDEN_UPGRADE_BASE_SLOT_DESCRIPTION_TEXT = class_2561.method_43471(class_156.method_646("item", class_2960.method_60654("smithing_template.warden_upgrade.base_slot_description")));
        WARDEN_UPGRADE_ADDITIONS_SLOT_DESCRIPTION_TEXT = class_2561.method_43471(class_156.method_646("item", class_2960.method_60654("smithing_template.warden_upgrade.additions_slot_description")));
    }
}