package net.trique.wardentools.item.staff;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.trique.wardentools.registry.ParticleRegistry;
import net.trique.wardentools.registry.TriggerTypeRegistry;

import java.util.HashSet;
import java.util.Set;

public class AmethystEchoStaffItem extends EchoStaffItem {


    public AmethystEchoStaffItem(class_1793 settings, int cooldown, int useDuration, int distance, int particleDelta, float damage, double horizontalKnockbackCoefficient, double verticalKnockbackCoefficient) {
        super(settings, cooldown, useDuration, distance, particleDelta, damage, horizontalKnockbackCoefficient, verticalKnockbackCoefficient);
    }

    @Override
    protected void spawnSonicBoom(class_1799 stack, class_3218 world, class_1309 user) {
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_38830, user.method_5634(), 2.0f, 1.0f);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_26940, user.method_5634(), 4.0f, 1.0f);
        class_243 source = user.method_19538().method_1031(0.0, user.method_5751(), 0.0);
        float enhanced_distance = calculateFinalDistance(stack, world, distance);
        class_243 target = source.method_1019(user.method_5720().method_1021(enhanced_distance));
        class_243 offsetToTarget = target.method_1020(source);
        class_243 normalized = offsetToTarget.method_1029();

        Set<class_1297> hit = new HashSet<>();
        for (int particleIndex = 1; particleIndex <= class_3532.method_15357(offsetToTarget.method_1033()) + particleDelta; ++particleIndex) {
            class_243 particlePos = source.method_1019(normalized.method_1021(particleIndex));
            world.method_14199(ParticleRegistry.AMETHYST_SONIC_BOOM.get(), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);

            hit.addAll(world.method_8390(class_1309.class, new class_238(new class_2338((int) particlePos.method_10216(),
                            (int) particlePos.method_10214(), (int) particlePos.method_10215())).method_1014(1),
                    it -> !(it.method_5722(user) || (it instanceof class_1321 helper && helper.method_6171(user)))));
        }

        hit.remove(user);

        for (class_1297 hitTarget : hit) {
            class_1282 damageSource = world.method_48963().method_48821(user);
            hitTarget.method_5643(damageSource, calculateEnchantedDamage(world, stack, hitTarget, damageSource, damage));
            if(hitTarget instanceof class_1309 living) {
                living.method_6092(new class_1293(class_1294.field_5902, 60, 1));
                double vertical = verticalKnockbackCoefficient * (1.0 - living.method_45325(class_5134.field_23718));
                double horizontal = horizontalKnockbackCoefficient * (1.0 - living.method_45325(class_5134.field_23718));
                living.method_5762(normalized.method_10216() * horizontal, normalized.method_10214() * vertical, normalized.method_10215() * horizontal);
            }
        }
        if (user instanceof class_3222 player) {
            TriggerTypeRegistry.AFFECTED_ENTITIES_TRIGGER.get().trigger(player, stack, hit);
        }
    }
}