package net.trique.wardentools.item.staff;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.trique.wardentools.item.util.ISonicBoomItem;
import net.trique.wardentools.registry.ItemRegistry;
import net.trique.wardentools.registry.TriggerTypeRegistry;

import java.util.HashSet;
import java.util.Set;

public class EchoStaffItem extends class_1792 implements ISonicBoomItem {
    protected int cooldown;
    protected int useDuration;
    protected int distance;
    protected int particleDelta;
    protected float damage;
    protected double horizontalKnockbackCoefficient;
    protected double verticalKnockbackCoefficient;

    public EchoStaffItem(class_1793 settings, int cooldown, int useDuration, int distance,
                         int particleDelta, float damage, double horizontalKnockbackCoefficient,
                         double verticalKnockbackCoefficient) {
        super(settings.method_57348(createAttributeModifiers()));
        this.cooldown = cooldown;
        this.useDuration = useDuration;
        this.distance = distance;
        this.particleDelta = particleDelta;
        this.damage = damage;
        this.horizontalKnockbackCoefficient = horizontalKnockbackCoefficient;
        this.verticalKnockbackCoefficient = verticalKnockbackCoefficient;
    }

    public static class_9285 createAttributeModifiers() {
        return class_9285.method_57480()
                .method_57487(class_5134.field_23721, new class_1322(field_8006, 3.0f, class_1322.class_1323.field_6328), class_9274.field_49217)
                .method_57487(class_5134.field_23723, new class_1322(field_8001, 0f, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
    }

    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }

    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(ItemRegistry.SCULK_SHELL.get());
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        boolean bl = !findEchoShard(user).method_7960();
        if (!user.method_56992() && !bl) {
            return class_1271.method_22431(itemStack);
        } else {
            user.method_6019(hand);
            return class_1271.method_22428(itemStack);
        }
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 usr) {
        return useDuration;
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);

        if (method_7881(stack, user) - remainingUseTicks == 1) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_38831, user.method_5634(), 3.0f, 1.0f);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (world instanceof class_3218 serverLevel && user instanceof class_1657 player) {
            class_1799 echoShardStack = findEchoShard(player);
            spawnSonicBoom(stack, serverLevel, player);
            if (!player.method_56992()) {
                echoShardStack.method_7934(1);
                player.method_7357().method_7906(this, cooldown);
                stack.method_7970(1, player, class_1304.field_6173);
            }
            player.method_7259(class_3468.field_15372.method_14956(this));
        }
        return super.method_7861(stack, world, user);
    }

    protected class_1799 findEchoShard(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_31574(class_1802.field_38746)) {
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    protected void spawnSonicBoom(class_1799 stack, class_3218 world, class_1309 user) {
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_38830, user.method_5634(), 5.0f, 1.0f);

        class_243 source = user.method_19538().method_1031(0.0, user.method_5751(), 0.0);
        float enhanced_distance = calculateFinalDistance(stack, world, distance);
        class_243 target = source.method_1019(user.method_5720().method_1021(enhanced_distance));
        class_243 offsetToTarget = target.method_1020(source);
        class_243 normalized = offsetToTarget.method_1029();

        Set<class_1297> hit = new HashSet<>();
        for (int particleIndex = 1; particleIndex <= class_3532.method_15357(offsetToTarget.method_1033()) + particleDelta; ++particleIndex) {
            class_243 particlePos = source.method_1019(normalized.method_1021(particleIndex));
            world.method_14199(class_2398.field_38908, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);

            hit.addAll(world.method_8390(class_1309.class, new class_238(new class_2338((int) particlePos.method_10216(),
                            (int) particlePos.method_10214(), (int) particlePos.method_10215())).method_1014(1),
                    it -> !(it.method_5722(user) || (it instanceof class_1321 helper && helper.method_6171(user)))));
        }

        hit.remove(user);

        for (class_1297 hitTarget : hit) {
            class_1282 damageSource = world.method_48963().method_48821(user);
            hitTarget.method_5643(damageSource, calculateEnchantedDamage(world, stack, hitTarget, damageSource, damage));
            if (hitTarget instanceof class_1309 living) {
                double vertical = verticalKnockbackCoefficient * (1.0 - living.method_45325(class_5134.field_23718));
                double horizontal = horizontalKnockbackCoefficient * (1.0 - living.method_45325(class_5134.field_23718));
                living.method_5762(normalized.method_10216() * horizontal, normalized.method_10214() * vertical, normalized.method_10215() * horizontal);
            }
        }
        if (user instanceof class_3222 player) {
            TriggerTypeRegistry.AFFECTED_ENTITIES_TRIGGER.get().trigger(player, stack, hit);
        }
    }
}