package net.trique.wardentools.item.staff;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_5712.class_7397;
import net.trique.wardentools.registry.ParticleRegistry;
import net.trique.wardentools.registry.TriggerTypeRegistry;

import java.util.HashSet;
import java.util.Set;

public class EnderEchoStaffItem extends EchoStaffItem {


    public EnderEchoStaffItem(class_1793 settings, int cooldown, int useDuration, int distance, int particleDelta, float damage, double horizontalKnockbackCoefficient, double verticalKnockbackCoefficient) {
        super(settings, cooldown, useDuration, distance, particleDelta, damage, horizontalKnockbackCoefficient, verticalKnockbackCoefficient);
    }

    @Override
    protected void spawnSonicBoom(class_1799 stack, class_3218 world, class_1309 user) {
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                class_3417.field_38830, user.method_5634(), 5.0f, 1.0f);
        class_243 source = user.method_19538().method_1031(0.0, user.method_5751(), 0.0);
        float enhanced_distance = calculateFinalDistance(stack, world, distance);
        class_243 target = source.method_1019(user.method_5720().method_1021(enhanced_distance));
        class_243 offsetToTarget = target.method_1020(source);
        class_243 normalized = offsetToTarget.method_1029();

        Set<class_1297> hit = new HashSet<>();
        for (int i = 1; i <= class_3532.method_15357(offsetToTarget.method_1033()) + particleDelta; ++i) {
            class_243 pos = source.method_1019(normalized.method_1021(i));
            world.method_14199(ParticleRegistry.ENDER_SONIC_BOOM.get(),
                    pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            hit.addAll(world.method_8390(class_1309.class,
                    new class_238(class_2338.method_49638(pos)).method_1014(1),
                    it -> !(it.method_5722(user) || (it instanceof class_1321 helper && helper.method_6171(user)))));
        }

        hit.remove(user);

        for (class_1297 hitTarget : hit) {
            class_1282 damageSource = world.method_48963().method_48821(user);
            hitTarget.method_5643(world.method_48963().method_48821(user), calculateEnchantedDamage(world, stack, hitTarget, damageSource, damage));
            if (hitTarget instanceof class_1309 living) {
                class_243 originalPos = living.method_19538();
                for (int j = 0; j < 16; ++j) {
                    double dx = living.method_23317() + (living.method_59922().method_43058() - 0.5) * 32.0;
                    double dy = class_3532.method_15350(
                            living.method_23318() + (double)(living.method_59922().method_43048(16) - 8),
                            world.method_31607(),
                            world.method_31607() + world.method_32819() - 1);
                    double dz = living.method_23321() + (living.method_59922().method_43058() - 0.5) * 32.0;
                    if (living.method_5765()) {
                        living.method_5848();
                    }
                    if (living.method_6082(dx, dy, dz, true)) {
                        world.method_32888(class_5712.field_39446, originalPos, class_7397.method_43285(living));
                        world.method_43128(null, dx, dy, dz,
                                class_3417.field_46945, class_3419.field_15245, 5.0F, 1.0F);
                        world.method_14199(class_2398.field_11214, dx, dy, dz, 40, 0.5, 0.5, 0.5, 0.1);
                        living.method_38785();
                        break;
                    }
                }
            }
        }
        if (user instanceof class_3222 player) {
            TriggerTypeRegistry.AFFECTED_ENTITIES_TRIGGER.get().trigger(player, stack, hit);
        }
    }
}