package net.trique.wardentools.loot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_7924;

public class AddEnchantedBookToPoolModifier extends ConditionalFabricLootModifier {

    private final class_5321<class_1887> enchantment;
    private final int minLevel;
    private final int maxLevel;

    public AddEnchantedBookToPoolModifier(class_5341[] conditionsIn, Set<class_2960> tables, class_5321<class_1887> enchantment, int minLevel, int maxLevel) {
        super(conditionsIn, tables);
        this.enchantment = enchantment;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 context, class_2960 lootTable) {
        if (!checkConditions(context, lootTable)) {
            return generatedLoot;
        }
        var enchantment = context.method_299().method_30349().method_30530(class_7924.field_41265).method_40290(this
                .enchantment);
        class_1799 bookStack = class_1772.method_7808(new class_1889(enchantment, context.method_294().method_39332(minLevel, maxLevel)));
        generatedLoot.add(bookStack);
        return generatedLoot;
    }
}
