package net.trique.wardentools.loot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;

public class AddItemModifier extends ConditionalFabricLootModifier {

    private final class_1792 item;
    private final int count;

    public AddItemModifier(class_5341[] conditionsIn, Set<class_2960> tables, class_1792 item, int count) {
        super(conditionsIn, tables);
        this.item = item;
        this.count = count;
    }

    public AddItemModifier(class_5341[] conditionsIn, Set<class_2960> tables, class_1792 item) {
        this(conditionsIn, tables, item, 1);
    }

    @Override
    public ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 lootContext, class_2960 lootTable) {
        if (!checkConditions(lootContext, lootTable)) {
            return generatedLoot;
        }
        generatedLoot.add(new class_1799(this.item, this.count));
        return generatedLoot;
    }
}