package net.trique.wardentools.loot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;

public class AddItemModifierWithRandomAmount extends ConditionalFabricLootModifier {
    private final class_1792 item;
    private final int min;
    private final int max;

    public AddItemModifierWithRandomAmount(class_5341[] conditionsIn, Set<class_2960> tables, class_1792 item, int min, int max) {
        super(conditionsIn, tables);
        this.item = item;
        this.min = min;
        this.max = max;
    }

    @Override
    public ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 lootContext, class_2960 lootTable) {
        if (!checkConditions(lootContext, lootTable)) {
            return generatedLoot;
        }

        int amount = lootContext.method_294().method_39332(this.min, this.max);
        generatedLoot.add(new class_1799(this.item, amount));
        return generatedLoot;
    }
}
