package net.trique.wardentools.loot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.trique.wardentools.util.WTEnchantmentHelper;

import java.util.Set;


public class AddItemToWardenLootModifier extends ConditionalFabricLootModifier {

    private final class_1792 item;
    private final float baseChance;
    private final float perLevel;
    private final int min;
    private final int max;

    public AddItemToWardenLootModifier(class_5341[] conditionsIn, Set<class_2960> tables, class_1792 item, float baseChance, float perLevel, int min, int max) {
        super(conditionsIn,tables);
        this.item = item;
        this.baseChance = baseChance;
        this.perLevel = perLevel;
        this.min = min;
        this.max = max;
    }

    @Override
    public ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 lootContext, class_2960 lootTable) {
        if (!checkConditions(lootContext, lootTable)) {
            return generatedLoot;
        }
        if (lootContext.method_296(class_181.field_1230) instanceof class_1309 entity) {
            int level = WTEnchantmentHelper.getMaxLevelForIncreaseEntityDrop(entity.method_6047(), lootContext);
            float lootingMultiplier = baseChance + perLevel * level;
            for (int count = max; count >= min; count--) {
                float countMultiplier = 1.0f / count;
                float chance = lootingMultiplier * countMultiplier;
                if (lootContext.method_294().method_43057() < chance) {
                    generatedLoot.add(new class_1799(item, count));
                    return generatedLoot;
                }
            }
        }
        return generatedLoot;
    }
}
