package net.trique.wardentools.loot;

import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;

public abstract class ConditionalFabricLootModifier implements FabricLootModifier {

    private final class_5341[] conditions;
    private final Set<class_2960> allowedTables;

    protected ConditionalFabricLootModifier(class_5341[] conditions, Set<class_2960> allowedTables) {
        this.conditions = conditions;
        this.allowedTables = allowedTables;
    }

    protected boolean checkConditions(class_47 context, class_2960 resourceLocation) {
        if (resourceLocation == null || !allowedTables.contains(resourceLocation)) return false;
        for (class_5341 condition : this.conditions) {
            if (!condition.test(context)) {
                return false;
            }
        }
        return true;
    }
}
