package net.trique.wardentools.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.serialization.Dynamic;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_5715;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import net.minecraft.class_8514;
import net.trique.wardentools.Constants;
import net.trique.wardentools.registry.EffectRegistry;
import net.trique.wardentools.util.WTBiomeTags;
import net.trique.wardentools.util.WTEntityTypeTags;
import net.trique.wardentools.util.warden_curse.WardenCurseUser;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.BiConsumer;


@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Unique
    private final WardenCurseUser wardentools$wardenCurseUser = new WardenCurseUser((class_1309) (Object) this);

    @Unique
    private final class_5715<class_8514.class_8516> wardentools$dynamicGameEventListener =
            new class_5715<>(new class_8514.class_8516(wardentools$wardenCurseUser));

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean hasEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract boolean removeEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract class_1293 getEffect(class_6880<class_1291> effect);

    @WrapMethod(method = "canBeAffected")
    private boolean preventDarknessIfSculkAdapted(class_1293 effectInstance, Operation<Boolean> original) {
        if (effectInstance.method_55654(class_1294.field_38092) && this.hasEffect(EffectRegistry.SCULK_ADAPTION)) {
            return false;
        }
        return original.call(effectInstance);
    }

    @Inject(method = "tick", at = @At("TAIL"))
    private void clearDarknessIfSculkAdapted(CallbackInfo ci) {
        if (!method_37908().method_8608()) {
            if (hasEffect(EffectRegistry.SCULK_ADAPTION)) {
                if (hasEffect(class_1294.field_38092)) {
                    removeEffect(class_1294.field_38092);
                }
            }
        }
    }

    @WrapMethod(method = "hurt")
    private boolean reduceDamageWithSculkScourge(class_1282 source, float amount, Operation<Boolean> original) {
        if (hasEffect(EffectRegistry.SCULK_SCOURGE) && (source.method_49708(class_8111.field_42333) ||
                (source.method_5529() instanceof class_1309 livingEntity &&
                        (livingEntity.method_5864().method_20210(WTEntityTypeTags.SCULK_SCOURGE_REDUCES_DAMAGE_FROM) ||
                                livingEntity.method_6059(EffectRegistry.SCULK_ADAPTION))))) {
            int amplifier = getEffect(EffectRegistry.SCULK_SCOURGE).method_5578();
            return original.call(source, amount * 0.1f * (amplifier + 1));
        }
        return original.call(source, amount);
    }

    @Override
    public boolean method_33189() {
        return hasEffect(EffectRegistry.SCULK_ADAPTION);
    }

    @Inject(method = "addAdditionalSaveData", at = @At("TAIL"))
    private void addVibrationDataFromWardenCurse(class_2487 compound, CallbackInfo ci) {
        class_8514.class_8515.field_44640.encodeStart(class_2509.field_11560, wardentools$wardenCurseUser.method_51298())
                .resultOrPartial(Constants.LOGGER::warn)
                .ifPresent(tag -> compound.method_10566("WTWardenCurseVibrationData", tag));
    }

    @Inject(method = "readAdditionalSaveData", at = @At("TAIL"))
    private void readVibrationDataForWardenCurse(class_2487 compound, CallbackInfo ci) {
        if (compound.method_10573("WTWardenCurseVibrationData", 10)) {
            class_8514.class_8515.field_44640.parse(new Dynamic<>(class_2509.field_11560, compound.method_10562("WTVibrationData")))
                    .resultOrPartial(Constants.LOGGER::warn).ifPresent(data -> wardentools$wardenCurseUser.setVibrationData(data));
        }
    }

    @Inject(method = "tick", at = @At("TAIL"))
    private void updateWardenCurseBonus(CallbackInfo ci) {
        class_1309 self = (class_1309) (Object) this;
        if (this.method_37908() instanceof class_3218 level) {
            if (self.method_6059(EffectRegistry.WARDEN_CURSE)) {
                class_6880<class_1959> currentBiome = level.method_23753(self.method_23312());
                if (currentBiome.method_40220(WTBiomeTags.WARDEN_CURSE_RECEIVE_BONUS_IN) && wardentools$wardenCurseUser.getExtraBonus() == 0) {
                    wardentools$wardenCurseUser.setExtraBonus(16);
                } else if (!currentBiome.method_40220(WTBiomeTags.WARDEN_CURSE_RECEIVE_BONUS_IN) && wardentools$wardenCurseUser.getExtraBonus() != 0) {
                    wardentools$wardenCurseUser.setExtraBonus(0);
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickWardenCurse(CallbackInfo ci) {
        if (method_37908() instanceof class_3218 serverLevel) {
//            Constants.LOGGER.info("amplifier: {}", wardentools$echolocateUser.getAmplifier());
            class_8514.class_8517.method_51406(serverLevel, wardentools$wardenCurseUser.method_51298(),
                    wardentools$wardenCurseUser.method_51299());
            wardentools$wardenCurseUser.tickCooldown();
        }
    }

    @Override
    public void method_42147(BiConsumer<class_5715<?>, class_3218> listenerConsumer) {
        if (method_37908() instanceof class_3218 level) {
            listenerConsumer.accept(wardentools$dynamicGameEventListener, level);
        }
    }

    @WrapMethod(method = "hurt")
    public boolean applyExtraDamageFromSculkBless(class_1282 source, float amount, Operation<Boolean> original) {
        if (source.method_5529() instanceof class_1309 attacker && attacker.method_6059(EffectRegistry.SCULK_SCOURGE) &&
                (method_5864().method_20210(WTEntityTypeTags.SCULK_SCOURGE_DEALS_EXTRA_DAMAGE_TO) ||
                        hasEffect(EffectRegistry.SCULK_ADAPTION))) {
            int amplifier = attacker.method_6112(EffectRegistry.SCULK_SCOURGE).method_5578();
            return original.call(source, amount * (1 + 0.25f * (1 + amplifier)));
        }
        return original.call(source, amount);
    }

}