package net.trique.wardentools.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import net.trique.wardentools.LootTableDuck;
import net.trique.wardentools.util.WTGlobalLootTableModifierUtils;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import java.util.function.Consumer;


@Debug(export = true)
@Mixin(class_52.class)
public abstract class LootTableMixinFabric implements LootTableDuck {
    @Shadow @Final private Optional<class_2960> randomSequence;

    @Shadow protected abstract ObjectArrayList<class_1799> getRandomItems(class_47 context);

    @Unique
    class_2960 id;

    @Override
    public class_2960 warden_tools$getId() {
        return id;
    }

    @Override
    public void warden_tools$setId(class_2960 resourceLocation) {
        if (resourceLocation != null) id = resourceLocation;
    }

    @Inject(method = "getRandomItems(Lnet/minecraft/world/level/storage/loot/LootContext;)Lit/unimi/dsi/fastutil/objects/ObjectArrayList;",
            at = @At("RETURN"))
    private void modifyLoot(class_47 context, CallbackInfoReturnable<ObjectArrayList<class_1799>> cir) {
        WTGlobalLootTableModifierUtils.modifyLoot((class_52) (Object) this, context, cir.getReturnValue());
    }

    /**
     * @author Tfar
     * @reason part of fabric GLMs
     */
    @Overwrite
    public void getRandomItems(class_8567 params, long seed, Consumer<class_1799> output) {
        this.getRandomItems(new class_47.class_48(params).method_304(seed).method_309(this.randomSequence)).forEach(output);
    }
}
