package net.trique.wardentools.particle.echo_particle;

import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.joml.Quaternionf;


public class EchoParticle extends class_4003 {
    private final float xRot;
    private final float yRot;

    public EchoParticle(class_638 level, double xCoord, double yCoord, double zCoord, class_4002 spriteSet,
                        double xSpeed, double ySpeed, double zSpeed, float xRot,float yRot) {
        super(level, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
        this.xRot = xRot;
        this.yRot = yRot;
        this.field_3874 = xCoord;
        this.field_3854 = yCoord;
        this.field_3871 = zCoord;
        this.field_3844 = 0.0f;
        field_3852 = field_3869 = field_3850 = 0;
        this.field_17867 = 0.2f;
        this.field_3847 = 5;
        this.method_18142(spriteSet);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        fadeOut();
    }

    @Override
    public void method_3074(class_4588 buffer, class_4184 camera, float partialTicks) {
       // this.alpha = 1.0F - Mth.clamp(((float) this.age + partialTicks) / (float) this.lifetime, 0.0F, 1.0F);
        Quaternionf quaternionf = new Quaternionf();
        float rotX = -(float) (xRot * Math.PI/180);
        float rotY = (float) (Math.PI- yRot * Math.PI/180);
        quaternionf.rotateYXZ(rotY, rotX, 0.0f);
        this.method_60373(buffer, camera, quaternionf, partialTicks);
        this.method_60373(buffer, camera, new Quaternionf(quaternionf).rotateY((float) Math.PI), partialTicks);
    }

    private void fadeOut() {
        this.field_3841 = (-(1 / (float) field_3847) * field_3866 + 1);
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public record Factory(class_4002 sprites) implements class_707<EchoParticleOption> {

        @Override
        public class_703 createParticle(EchoParticleOption echoParticleOption, class_638 clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float scale = echoParticleOption.scale();
            EchoParticle particle = new EchoParticle(clientLevel, x, y, z, sprites, xSpeed, ySpeed, zSpeed,echoParticleOption.rotX(),echoParticleOption.rotY());
            return particle.method_3087(scale);
        }
    }
}
