package net.trique.wardentools.particle.echo_particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.trique.wardentools.registry.ParticleRegistry;

public record EchoParticleOption(float scale, float rotX, float rotY) implements class_2394 {
    public static final MapCodec<EchoParticleOption> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.FLOAT.fieldOf("scale").forGetter(EchoParticleOption::scale),
            Codec.FLOAT.fieldOf("rotX").forGetter(EchoParticleOption::rotX),
            Codec.FLOAT.fieldOf("rotY").forGetter(EchoParticleOption::rotY)
    ).apply(instance, EchoParticleOption::new));

    public static final class_9139<ByteBuf, EchoParticleOption> STREAM_CODEC = class_9139.method_56436(
            class_9135.field_48552, EchoParticleOption::scale,
            class_9135.field_48552, EchoParticleOption::rotX,
            class_9135.field_48552, EchoParticleOption::rotY,
            EchoParticleOption::new);

    @Override
    public class_2396<EchoParticleOption> method_10295() {
        return ParticleRegistry.ECHO_PARTICLE.get();
    }
}
