package net.trique.wardentools.registry;

import net.minecraft.class_1747;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5542;
import net.minecraft.class_6019;
import net.minecraft.class_7924;
import net.minecraft.world.level.block.*;
import net.trique.wardentools.Constants;
import net.trique.wardentools.block.BuddingSculkhystBlock;
import net.trique.wardentools.block.SculkhystBlock;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;

import java.util.function.Function;
import java.util.function.Supplier;

public class BlockRegistry {

    protected static final RegistrationProvider<class_2248> BLOCKS = RegistrationProvider.get(class_7924.field_41254, Constants.MOD_ID);

    public static final RegistryObject<class_2248, SculkhystBlock> SCULKHYST_BLOCK = registerBlock("sculkhyst_block", () ->
            new SculkhystBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16026).method_9632(1.5f).method_9626(class_2498.field_37644), class_6019.method_35017(8, 16)));

    public static final RegistryObject<class_2248, BuddingSculkhystBlock> BUDDING_SCULKHYST = registerBlock("budding_sculkhyst", () ->
            new BuddingSculkhystBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16026).method_9640().method_9632(1.5f).method_9626(class_2498.field_37644).method_50012(class_3619.field_15971)));

    public static final RegistryObject<class_2248, class_5542> SCULKHYST_CLUSTER = registerBlock("sculkhyst_cluster", () ->
            new class_5542(7, 3, class_4970.class_2251.method_9637().method_31710(class_3620.field_16026).method_51369().method_22488().method_9640().method_9626(class_2498.field_37644).method_9632(1.5f).method_9631(state -> 4).method_50012(class_3619.field_15971)));

    public static final RegistryObject<class_2248, class_5542> LARGE_SCULKHYST_BUD = registerBlock("large_sculkhyst_bud", () ->
            new class_5542(5, 3, class_4970.class_2251.method_9630(SCULKHYST_CLUSTER.get()).method_9626(class_2498.field_37644).method_51369().method_9631(state -> 3).method_50012(class_3619.field_15971)));

    public static final RegistryObject<class_2248, class_5542> MEDIUM_SCULKHYST_BUD = registerBlock("medium_sculkhyst_bud", () ->
            new class_5542(4, 3, class_4970.class_2251.method_9630(SCULKHYST_CLUSTER.get()).method_9626(class_2498.field_37644).method_51369().method_9631(state -> 2).method_50012(class_3619.field_15971)));

    public static final RegistryObject<class_2248, class_5542> SMALL_SCULKHYST_BUD = registerBlock("small_sculkhyst_bud", () ->
            new class_5542(3, 4, class_4970.class_2251.method_9630(SCULKHYST_CLUSTER.get()).method_9626(class_2498.field_37644).method_51369().method_9631(state -> 1).method_50012(class_3619.field_15971)));

    public static final RegistryObject<class_2248, class_2248> BLOCK_OF_AMETHYST_INGOTS = registerBlock("block_of_amethyst_ingots", () ->
            new class_2248(class_4970.class_2251.method_9630(class_2246.field_10201).method_31710(class_3620.field_16014).method_9626(class_2498.field_27197)));

    public static final RegistryObject<class_2248, class_2248> ROSE_GOLD_BLOCK = registerBlock("rose_gold_block", () ->
            new class_2248(class_4970.class_2251.method_9630(class_2246.field_10205).method_31710(class_3620.field_15989)));

    public static final RegistryObject<class_2248, class_2248> ECHO_BLOCK = registerBlock("echo_block", () ->
            new class_2248(class_4970.class_2251.method_9630(class_2246.field_10201).method_31710(class_3620.field_16024)));

    public static final RegistryObject<class_2248, class_2248> WARDEN_BLOCK = registerBlock("warden_block", () ->
            new class_2248(class_4970.class_2251.method_9630(class_2246.field_22108).method_31710(class_3620.field_16026).method_9626(class_2498.field_37643)));



    public static void init() {
        Constants.LOGGER.info("Registering blocks for {}", Constants.MOD_NAME);
    }


    protected static <T extends class_2248> RegistryObject<class_2248, T> registerBlock(String name, Supplier<T> block) {
        return registerBlock(name, block, b -> () -> new class_1747(b.get(), ItemRegistry.getItemProperties()));
    }

    protected static <T extends class_2248> RegistryObject<class_2248, T> registerBlock(String name, Supplier<T> block, Function<RegistryObject<class_2248, T>, Supplier<? extends class_1747>> item) {
        var reg = BLOCKS.register(name, block);
        ItemRegistry.ITEMS.register(name, () -> item.apply(reg).get());
        return reg;
    }

    public static Iterable<class_2248> getModBlocks() {
        return BlockRegistry.BLOCKS.getEntries().stream().map((blockRegistryObject -> (class_2248) blockRegistryObject.get()))::iterator;
    }
}
