package net.trique.wardentools.registry;

import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1889;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.world.item.*;
import net.trique.wardentools.Constants;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;
import net.trique.wardentools.util.WTEnchantments;

import java.util.List;

import static net.trique.wardentools.registry.BlockRegistry.*;
import static net.trique.wardentools.registry.ItemRegistry.*;
import static net.trique.wardentools.util.ModHelper.getTranslationKey;


public class CreativeTabRegistry {
    public static void init() {
        Constants.LOGGER.info("Adding creative tab for {}", Constants.MOD_NAME);
    }

    protected static final RegistrationProvider<class_1761> CREATIVE_MODE_TABS = RegistrationProvider.get(class_7924.field_44688, Constants.MOD_ID);


    public static final RegistryObject<class_1761, class_1761> WARDEN_TOOLS_BLOCKS_TAB = CREATIVE_MODE_TABS.register("blocks",
            () -> class_1761.method_47307(class_1761.class_7915.field_41049, 0)
                    .method_47320(() -> new class_1799(WARDEN_BLOCK.get()))
                    .method_47321(class_2561.method_43471(creativeTabKey("blocks")))
                    .method_47317(
                            (itemDisplayParameters, output) -> {
                                output.method_45421(SCULKHYST_BLOCK.get());
                                output.method_45421(BUDDING_SCULKHYST.get());
                                output.method_45421(SMALL_SCULKHYST_BUD.get());
                                output.method_45421(MEDIUM_SCULKHYST_BUD.get());
                                output.method_45421(LARGE_SCULKHYST_BUD.get());
                                output.method_45421(SCULKHYST_CLUSTER.get());
                                output.method_45421(ROSE_GOLD_BLOCK.get());
                                output.method_45421(BLOCK_OF_AMETHYST_INGOTS.get());
                                output.method_45421(ECHO_BLOCK.get());
                                output.method_45421(WARDEN_BLOCK.get());
                            })
                    .method_47324());

    public static final RegistryObject<class_1761, class_1761> WARDEN_TOOLS_EQUIPMENT_TAB = CREATIVE_MODE_TABS.register("equipment",
            () -> class_1761.method_47307(class_1761.class_7915.field_41049, 1)
                    .method_47321(class_2561.method_43471(creativeTabKey("equipment")))
                    .method_47320(() -> new class_1799(WARDEN_CHESTPLATE.get()))
                    .method_47317(
                            (itemDisplayParameters, output) -> {
                                output.method_45421(SCULKIFIED_SHOVEL.get());
                                output.method_45421(SCULKIFIED_PICKAXE.get());
                                output.method_45421(SCULKIFIED_AXE.get());
                                output.method_45421(SCULKIFIED_HOE.get());
                                output.method_45421(SCULKIFIED_SWORD.get());
                                output.method_45421(SCULKIFIED_HELMET.get());
                                output.method_45421(SCULKIFIED_CHESTPLATE.get());
                                output.method_45421(SCULKIFIED_LEGGINGS.get());
                                output.method_45421(SCULKIFIED_BOOTS.get());
                                output.method_45421(WARDEN_SHOVEL.get());
                                output.method_45421(WARDEN_PICKAXE.get());
                                output.method_45421(WARDEN_AXE.get());
                                output.method_45421(WARDEN_HOE.get());
                                output.method_45421(WARDEN_SWORD.get());
                                output.method_45421(WARDEN_HELMET.get());
                                output.method_45421(WARDEN_MASK.get());
                                output.method_45421(WARDEN_CHESTPLATE.get());
                                output.method_45421(WARDEN_LEGGINGS.get());
                                output.method_45421(WARDEN_BOOTS.get());
                                output.method_45421(ECHO_STAFF.get());
                                output.method_45421(ROSE_GOLD_UPGRADED_ECHO_STAFF.get());
                                output.method_45421(AMETHYST_UPGRADED_ECHO_STAFF.get());
                                output.method_45421(ENDER_UPGRADED_ECHO_STAFF.get());
                                output.method_45421(ECHO_SHRIEKER.get());
                                output.method_45421(ECHO_LOCATOR.get());
                                output.method_45421(SCULK_ARROW.get());
                                for (class_6880<class_1842> potionHolder : PotionRegistry.getEntries()) {
                                    output.method_45420(class_1844.method_57400(class_1802.field_8087, potionHolder));
                                }
                            })
                    .method_47324());

    public static final RegistryObject<class_1761, class_1761> WARDEN_TOOLS_MISC = CREATIVE_MODE_TABS.register("misc",
            () -> class_1761.method_47307(class_1761.class_7915.field_41049, 2)
                    .method_47321(class_2561.method_43471(creativeTabKey("misc")))
                    .method_47320(() -> new class_1799(WARDEN_UPGRADE_SMITHING_TEMPLATE.get()))
                    .method_47317(
                            (itemDisplayParameters, output) -> {
                                output.method_45421(ECHO_APPLE.get());
                                output.method_45421(ECHO_INGOT.get());
                                output.method_45421(WARDEN_INGOT.get());
                                output.method_45421(ROSE_GOLD_INGOT.get());
                                output.method_45421(AMETHYST_INGOT.get());
                                output.method_45421(WARDEN_UPGRADE_SMITHING_TEMPLATE.get());
                                output.method_45421(WARDEN_SOUL.get());
                                output.method_45421(SCULK_SHELL.get());
                                output.method_45421(SHRIEKER_FANG.get());
                                output.method_45421(WARDEN_TENDRIL.get());
                                var echo_concentration = itemDisplayParameters.comp_1253().method_46762(class_7924.field_41265).method_46747(WTEnchantments.SONIC_BOOST);
                                var resonation = itemDisplayParameters.comp_1253().method_46762(class_7924.field_41265).method_46747(WTEnchantments.PROPAGATION);
                                output.method_45420(class_1772.method_7808(new class_1889(echo_concentration, echo_concentration.comp_349().method_8183())));
                                output.method_45420(class_1772.method_7808(new class_1889(resonation, resonation.comp_349().method_8183())));
                            }
                    )
                    .method_47324());

    public static final RegistryObject<class_1761, class_1761> WARDEN_TOOLS_POTIONS = CREATIVE_MODE_TABS.register("potions",
            () -> class_1761.method_47307(class_1761.class_7915.field_41049, 3)
                    .method_47321(class_2561.method_43471(creativeTabKey("potions")))
                    .method_47320(() -> class_1844.method_57400(class_1802.field_8574, PotionRegistry.SCULK_ADAPTION))
                    .method_47317(
                            (itemDisplayParameters, output) -> {
                                for (class_6880<class_1842> potionHolder : PotionRegistry.getEntries()) {
                                    for (class_1792 base : List.of(class_1802.field_8574, class_1802.field_8436,
                                            class_1802.field_8150)) {
                                        output.method_45420(class_1844.method_57400(base, potionHolder));
                                    }
                                }
                            }
                    )
                    .method_47324());


    private static String creativeTabKey(String name) {
        return getTranslationKey("creative_tab." + name);
    }
}
