package net.trique.wardentools.registry;

import net.minecraft.class_1291;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.trique.wardentools.Constants;
import net.trique.wardentools.effect.*;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;

import java.util.function.Supplier;

public class EffectRegistry {
    protected static final RegistrationProvider<class_1291> EFFECTS = RegistrationProvider.get(class_7924.field_41208, Constants.MOD_ID);

    public static class_6880<class_1291> SCULK_ADAPTION;
    public static class_6880<class_1291> WARDEN_CURSE;
    public static class_6880<class_1291> SCULK_SCOURGE;

    private static <T extends class_1291> class_6880<class_1291> registerEffect(String name, Supplier<T> effectSupplier) {
        RegistryObject<class_1291, T> effectObject = EFFECTS.register(name, effectSupplier);
        return effectObject.asHolder();
    }


    public static void init() {
        Constants.LOGGER.info("Registering Effects for {}...", Constants.MOD_NAME);
    }

    static {
        SCULK_ADAPTION = registerEffect("sculk_adaption", () -> new SculkAdaptionEffect(class_4081.field_18271, 0x009295));
        SCULK_SCOURGE = registerEffect("sculk_scourge", () -> new SculkScourgeEffect(class_4081.field_18271, 0x0A5060));
        WARDEN_CURSE = registerEffect("warden_curse", () -> new WardenCurseEffect(class_4081.field_18273, 0x034150));
    }
}