package net.trique.wardentools.registry;

import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9723;
import net.trique.wardentools.Constants;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;

import java.util.function.UnaryOperator;

public class EnchantmentEffectComponentRegistry {
    private static final RegistrationProvider<class_9331<?>> ENCHANTMENT_EFFECT_COMPONENT_PROVIDER = RegistrationProvider.get(
            class_7923.field_51832, Constants.MOD_ID
    );

    public static RegistryObject<class_9331<?>, class_9331<class_9723>> INCREASE_RANGE =
            register("increase_range",
            (builder -> builder.method_57881(class_9723.field_51709)));


    public static void init() {
        Constants.LOGGER.info("Registering warden enchantment effect components...");
    }

    protected static <T> RegistryObject<class_9331<?>, class_9331<T>> register(String name, UnaryOperator<class_9331.class_9332<T>> operator) {
        return ENCHANTMENT_EFFECT_COMPONENT_PROVIDER.register(name, () -> operator.apply(class_9331.method_57873()).method_59871().method_57880());
    }
}
