package net.trique.wardentools.registry;

import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1814;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_7924;
import net.minecraft.world.item.*;
import net.trique.wardentools.Constants;
import net.trique.wardentools.item.archery.EchoShriekerItem;
import net.trique.wardentools.item.archery.SculkArrowItem;
import net.trique.wardentools.item.archery.EchoLocatorItem;
import net.trique.wardentools.item.material.WardenArmorMaterials;
import net.trique.wardentools.item.material.WardenToolMaterials;
import net.trique.wardentools.item.melee.*;
import net.trique.wardentools.item.armor.WardenArmorItem;
import net.trique.wardentools.item.armor.WardenMaskItem;
import net.trique.wardentools.item.misc.WardenFoodItem;
import net.trique.wardentools.item.misc.WardenTemplateItem;
import net.trique.wardentools.item.staff.AmethystEchoStaffItem;
import net.trique.wardentools.item.staff.EchoStaffItem;
import net.trique.wardentools.item.staff.EnderEchoStaffItem;
import net.trique.wardentools.item.staff.RoseGoldEchoStaffItem;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;

public class ItemRegistry {
    protected static final RegistrationProvider<class_1792> ITEMS = RegistrationProvider.get(class_7924.field_41197, Constants.MOD_ID);

    public static final RegistryObject<class_1792, EchoStaffItem> ECHO_STAFF = ITEMS.register("echo_staff",
            () -> new EchoStaffItem(getItemProperties().method_7894(class_1814.field_8904).method_7895(76),
                    80, 20, 20, 7, 10.0f, 5.0, 1.0));

    public static final RegistryObject<class_1792, AmethystEchoStaffItem> AMETHYST_UPGRADED_ECHO_STAFF = ITEMS.register("amethyst_upgraded_echo_staff",
            () -> new AmethystEchoStaffItem(getItemProperties().method_7894(class_1814.field_8904).method_7895(76),
                    60, 15, 20, 7, 10.0f, 7.5, 1.5));

    public static final RegistryObject<class_1792, EnderEchoStaffItem> ENDER_UPGRADED_ECHO_STAFF = ITEMS.register("ender_upgraded_echo_staff",
            () -> new EnderEchoStaffItem(getItemProperties().method_7894(class_1814.field_8904).method_7895(76),
                    80, 20, 20, 7, 10.0f, 5.0, 1.0));

    public static final RegistryObject<class_1792, RoseGoldEchoStaffItem> ROSE_GOLD_UPGRADED_ECHO_STAFF = ITEMS.register("rose_gold_upgraded_echo_staff",
            () -> new RoseGoldEchoStaffItem(getItemProperties().method_7894(class_1814.field_8904).method_7895(76),
                    80, 20, 40, 7, 20.0f, 2.5, 0.5));

    public static final RegistryObject<class_1792, EchoShriekerItem> ECHO_SHRIEKER = ITEMS.register("echo_shrieker",
            () -> new EchoShriekerItem(getFireResistantProperties().method_7894(class_1814.field_8904).method_7895(50)));

    public static final RegistryObject<class_1792, EchoLocatorItem> ECHO_LOCATOR = ITEMS.register("echo_locator", () ->
            new EchoLocatorItem(getFireResistantProperties().method_7894(class_1814.field_8903).method_57348(EchoLocatorItem.createAttributeModifiers())));

    public static final RegistryObject<class_1792, class_1821> SCULKIFIED_SHOVEL = ITEMS.register("sculkified_shovel", () ->
            new class_1821(WardenToolMaterials.SCULKIFIED, getItemProperties().method_57348(class_1821.method_57346(WardenToolMaterials.SCULKIFIED, 1.5f, -3.0f))));

    public static final RegistryObject<class_1792, class_1810> SCULKIFIED_PICKAXE = ITEMS.register("sculkified_pickaxe", () ->
            new class_1810(WardenToolMaterials.SCULKIFIED, getItemProperties().method_57348(class_1810.method_57346(WardenToolMaterials.SCULKIFIED, 1f, -2.8f))));

    public static final RegistryObject<class_1792, class_1743> SCULKIFIED_AXE = ITEMS.register("sculkified_axe", () ->
            new class_1743(WardenToolMaterials.SCULKIFIED, getItemProperties().method_57348(DarknessAxeItem.method_57346(WardenToolMaterials.SCULKIFIED, 5, -2.9f))));

    public static final RegistryObject<class_1792, class_1794> SCULKIFIED_HOE = ITEMS.register("sculkified_hoe", () ->
            new class_1794(WardenToolMaterials.SCULKIFIED, getItemProperties().method_57348(class_1794.method_57346(WardenToolMaterials.SCULKIFIED, -4, 0.0f))));

    public static final RegistryObject<class_1792, class_1829> SCULKIFIED_SWORD = ITEMS.register("sculkified_sword", () ->
            new class_1829(WardenToolMaterials.SCULKIFIED, getItemProperties().method_57348(DarknessSwordItem.method_57394(WardenToolMaterials.SCULKIFIED, 3, -2.4f))));

    public static final RegistryObject<class_1792, WardenArmorItem> SCULKIFIED_HELMET = ITEMS.register("sculkified_helmet", () ->
            new WardenArmorItem(WardenArmorMaterials.SCULKIFIED, class_1738.class_8051.field_41934, getItemProperties().method_7895(class_1738.class_8051.field_41934.method_56690(40)),
                    WTArmorSets.SCULKIFIED_SET));

    public static final RegistryObject<class_1792, WardenArmorItem> SCULKIFIED_CHESTPLATE = ITEMS.register("sculkified_chestplate", () ->
            new WardenArmorItem(WardenArmorMaterials.SCULKIFIED, class_1738.class_8051.field_41935, getItemProperties().method_7895(class_1738.class_8051.field_41935.method_56690(40)),
                    WTArmorSets.SCULKIFIED_SET));

    public static final RegistryObject<class_1792, WardenArmorItem> SCULKIFIED_LEGGINGS = ITEMS.register("sculkified_leggings", () ->
            new WardenArmorItem(WardenArmorMaterials.SCULKIFIED, class_1738.class_8051.field_41936, getItemProperties().method_7895(class_1738.class_8051.field_41936.method_56690(40)),
                    WTArmorSets.SCULKIFIED_SET));

    public static final RegistryObject<class_1792, WardenArmorItem> SCULKIFIED_BOOTS = ITEMS.register("sculkified_boots", () ->
            new WardenArmorItem(WardenArmorMaterials.SCULKIFIED, class_1738.class_8051.field_41937, getItemProperties().method_7895(class_1738.class_8051.field_41937.method_56690(40)),
                    WTArmorSets.SCULKIFIED_SET));

    public static final RegistryObject<class_1792, class_1821> WARDEN_SHOVEL = ITEMS.register("warden_shovel", () ->
            new DarknessShovelItem(WardenToolMaterials.WARDEN, getFireResistantProperties().method_57348(class_1821.method_57346(WardenToolMaterials.WARDEN, 1.5f, -3.0f))));

    public static final RegistryObject<class_1792, class_1810> WARDEN_PICKAXE = ITEMS.register("warden_pickaxe", () ->
            new DarknessPickaxeItem(WardenToolMaterials.WARDEN, getFireResistantProperties().method_57348(class_1810.method_57346(WardenToolMaterials.WARDEN, 1f, -2.8f))));

    public static final RegistryObject<class_1792, DarknessAxeItem> WARDEN_AXE = ITEMS.register("warden_axe", () ->
            new DarknessAxeItem(WardenToolMaterials.WARDEN, getFireResistantProperties().method_57348(DarknessAxeItem.method_57346(WardenToolMaterials.WARDEN, 5, -2.9f))));

    public static final RegistryObject<class_1792, class_1794> WARDEN_HOE = ITEMS.register("warden_hoe", () ->
            new DarknessHoeItem(WardenToolMaterials.WARDEN, getFireResistantProperties().method_57348(class_1794.method_57346(WardenToolMaterials.WARDEN, -4, 0.0f))));

    public static final RegistryObject<class_1792, DarknessSwordItem> WARDEN_SWORD = ITEMS.register("warden_sword", () ->
            new DarknessSwordItem(WardenToolMaterials.WARDEN, getFireResistantProperties().method_57348(DarknessSwordItem.method_57394(WardenToolMaterials.WARDEN, 3, -2.4f))));

    public static final RegistryObject<class_1792, WardenArmorItem> WARDEN_HELMET = ITEMS.register("warden_helmet", () ->
            new WardenArmorItem(WardenArmorMaterials.WARDEN, class_1738.class_8051.field_41934, getFireResistantProperties().method_7895(class_1738.class_8051.field_41934.method_56690(45)),
                    WTArmorSets.WARDEN_SET));

    public static final RegistryObject<class_1792, WardenMaskItem> WARDEN_MASK = ITEMS.register("warden_mask", () ->
            new WardenMaskItem(WardenArmorMaterials.WARDEN, class_1738.class_8051.field_41934, getFireResistantProperties().method_7895(class_1738.class_8051.field_41934.method_56690(45)).method_7894(class_1814.field_8904),
                    WTArmorSets.WARDEN_SET));

    public static final RegistryObject<class_1792, WardenArmorItem> WARDEN_CHESTPLATE = ITEMS.register("warden_chestplate", () ->
            new WardenArmorItem(WardenArmorMaterials.WARDEN, class_1738.class_8051.field_41935, getFireResistantProperties().method_7895(class_1738.class_8051.field_41935.method_56690(45)),
                    WTArmorSets.WARDEN_SET));

    public static final RegistryObject<class_1792, WardenArmorItem> WARDEN_LEGGINGS = ITEMS.register("warden_leggings", () ->
            new WardenArmorItem(WardenArmorMaterials.WARDEN, class_1738.class_8051.field_41936, getFireResistantProperties().method_7895(class_1738.class_8051.field_41936.method_56690(45)),
                    WTArmorSets.WARDEN_SET));

    public static final RegistryObject<class_1792, WardenArmorItem> WARDEN_BOOTS = ITEMS.register("warden_boots", () ->
            new WardenArmorItem(WardenArmorMaterials.WARDEN, class_1738.class_8051.field_41937, getFireResistantProperties().method_7895(class_1738.class_8051.field_41937.method_56690(45)),
                    WTArmorSets.WARDEN_SET));

    public static final RegistryObject<class_1792, class_1792> SCULK_SHELL = ITEMS.register("sculk_shell", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8903).method_19265(WardenFoodItem.getSculkShellProperties())));

    public static final RegistryObject<class_1792, class_1792> WARDEN_TENDRIL = ITEMS.register("warden_tendril", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8904)));

    public static final RegistryObject<class_1792, class_1792> SHRIEKER_FANG = ITEMS.register("shrieker_fang", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8903)));

    public static final RegistryObject<class_1792, class_1792> ECHO_APPLE = ITEMS.register("echo_apple", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8903).method_19265(WardenFoodItem.getEchoAppleProperties())));

    public static final RegistryObject<class_1792, class_1792> WARDEN_SOUL = ITEMS.register("warden_soul", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8903)));

    public static final RegistryObject<class_1792, class_1792> WARDEN_INGOT = ITEMS.register("warden_ingot", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8903)));

    public static final RegistryObject<class_1792, class_1792> ECHO_INGOT = ITEMS.register("echo_ingot", () ->
            new class_1792(getItemProperties().method_7894(class_1814.field_8907)));

    public static final RegistryObject<class_1792, class_1792> ROSE_GOLD_INGOT = ITEMS.register("rose_gold_ingot", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8907)));

    public static final RegistryObject<class_1792, class_1792> AMETHYST_INGOT = ITEMS.register("amethyst_ingot", () ->
            new class_1792(getFireResistantProperties().method_7894(class_1814.field_8907)));

    public static final RegistryObject<class_1792, SculkArrowItem> SCULK_ARROW = ITEMS.register("sculk_arrow", () ->
            new SculkArrowItem(getFireResistantProperties()));

    public static final RegistryObject<class_1792, WardenTemplateItem> WARDEN_UPGRADE_SMITHING_TEMPLATE =
            ITEMS.register("warden_upgrade_smithing_template", WardenTemplateItem::createWardenUpgrade);


    public static class_1792.class_1793 getItemProperties() {
        return new class_1792.class_1793();
    }

    public static class_1792.class_1793 getFireResistantProperties() {
        return new class_1792.class_1793().method_24359();
    }

    public static void init() {
        Constants.LOGGER.info("Registering items for {}...", Constants.MOD_NAME);
    }
}
