package net.trique.wardentools.registry;

import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_7924;
import net.trique.wardentools.Constants;
import net.trique.wardentools.particle.echo_particle.EchoParticleType;
import net.trique.wardentools.platform.Services;
import net.trique.wardentools.registration.RegistrationProvider;
import net.trique.wardentools.registration.RegistryObject;

public class ParticleRegistry {
    protected static final RegistrationProvider<class_2396<?>> PARTICLE_TYPES = RegistrationProvider.get(class_7924.field_41210, Constants.MOD_ID);

    public static final RegistryObject<class_2396<?>, EchoParticleType> ECHO_PARTICLE = PARTICLE_TYPES.register("echo_particle", () -> new EchoParticleType(false));
    public static final RegistryObject<class_2396<?>, class_2400> ROSE_GOLD_SONIC_BOOM = PARTICLE_TYPES.register("rose_gold_sonic_boom", Services.PARTICLE_HELPER::getSimpleParticle);
    public static final RegistryObject<class_2396<?>, class_2400> AMETHYST_SONIC_BOOM = PARTICLE_TYPES.register("amethyst_sonic_boom", Services.PARTICLE_HELPER::getSimpleParticle);
    public static final RegistryObject<class_2396<?>, class_2400> ENDER_SONIC_BOOM = PARTICLE_TYPES.register("ender_sonic_boom", Services.PARTICLE_HELPER::getSimpleParticle);
    public static void init() {
        Constants.LOGGER.info("Registering particles for Warden Tools...");
    }
}
