package net.trique.wardentools.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_219;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.trique.wardentools.LootTableDuck;
import net.trique.wardentools.loot.*;
import net.trique.wardentools.registry.ItemRegistry;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WTGlobalLootTableModifierUtils {

    private static final class_2960 ANCIENT_CITY_LOOT_LOCATION = class_39.field_38438.method_29177();
    private static final class_2960 SCULK_SHRIEKER_LOOT_LOCATION = class_2246.field_37571.method_26162().method_29177();
    private static final class_2960 WARDEN_LOOT_LOCATION = class_1299.field_38095.method_16351().method_29177();

    public static final List<FabricLootModifier> MODIFIERS = new ArrayList<>();

    public static void addModifiers() {
        insertIDs();
        MODIFIERS.add(new AddItemModifier(new class_5341[]{class_219.method_932(.1f).build()},
                Set.of(ANCIENT_CITY_LOOT_LOCATION), ItemRegistry.WARDEN_UPGRADE_SMITHING_TEMPLATE.get()));

        MODIFIERS.add(new AddItemModifier(new class_5341[]{class_219.method_932(.25f).build()},
                Set.of(ANCIENT_CITY_LOOT_LOCATION), ItemRegistry.SCULK_SHELL.get()));

        MODIFIERS.add(new AddItemModifierWithRandomAmount(new class_5341[]{class_219.method_932(.5f).build()},
                Set.of(ANCIENT_CITY_LOOT_LOCATION), ItemRegistry.ECHO_APPLE.get(), 1, 3));

        MODIFIERS.add(new AddItemModifierWithRandomAmount(new class_5341[]{class_219.method_932(.5f).build()},
                Set.of(ANCIENT_CITY_LOOT_LOCATION), class_1802.field_38746, 1, 3));
        MODIFIERS.add(new AddEnchantedBookToPoolModifier(new class_5341[]{class_219.method_932(0.33f).build()},
                Set.of(ANCIENT_CITY_LOOT_LOCATION), WTEnchantments.SONIC_BOOST, 1, 5));
        MODIFIERS.add(new AddEnchantedBookToPoolModifier(new class_5341[]{class_219.method_932(0.25f).build()},
                Set.of(ANCIENT_CITY_LOOT_LOCATION), WTEnchantments.PROPAGATION, 1, 3));


        MODIFIERS.add(new AddItemToWardenLootModifier(new class_5341[0],
                Set.of(WARDEN_LOOT_LOCATION), ItemRegistry.WARDEN_SOUL.get(), 0.3f, 0.1f, 1, 2));

        MODIFIERS.add(new AddItemToWardenLootModifier(new class_5341[0],
                Set.of(WARDEN_LOOT_LOCATION), ItemRegistry.WARDEN_TENDRIL.get(), 0.4f, 0.1f, 1, 2));


        MODIFIERS.add(new AddItemToShriekerLootModifier(new class_5341[0],
                Set.of(SCULK_SHRIEKER_LOOT_LOCATION), ItemRegistry.WARDEN_SOUL.get(), 0.05f, 0.05f, 1, 2));

        MODIFIERS.add(new AddItemToShriekerLootModifier(new class_5341[0],
                Set.of(SCULK_SHRIEKER_LOOT_LOCATION), ItemRegistry.SHRIEKER_FANG.get(), 0.3f, 0.1f, 1, 4));

    }

    public static void modifyLoot(class_52 lootTable, class_47 context, ObjectArrayList<class_1799> loot) {
        class_2960 id = ((LootTableDuck) lootTable).warden_tools$getId();
        MODIFIERS.forEach(fabricLootModifier -> fabricLootModifier.doApply(loot, context, id));
    }


    private static void insertIDs() {
        LootTableEvents.ALL_LOADED.register(((resourceManager, lootRegistry) -> {
            lootRegistry.forEach(lootTable -> {
                ((LootTableDuck) lootTable).warden_tools$setId(lootRegistry.method_10221(lootTable));
            });
        }));
    }
}
