package net.trique.wardentools.util;

import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_219;
import net.minecraft.class_2246;
import net.minecraft.class_225;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import net.minecraft.class_9704;
import net.trique.wardentools.registry.ItemRegistry;

public class WTLootTableModifiers {
    private static final class_2960 ANCIENT_CITY_LOOT_LOCATION = class_39.field_38438.method_29177();
    private static final class_2960 SCULK_SHRIEKER_LOOT_LOCATION = class_2246.field_37571.method_26162().method_29177();
    private static final class_2960 WARDEN_LOOT_LOCATION = class_1299.field_38095.method_16351().method_29177();

    public static void modifyLootTables() {
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            if (ANCIENT_CITY_LOOT_LOCATION.equals(key.method_29177())) {
                class_55.class_56 templatePoolBuilder = class_55.method_347()
                        .method_356(class_219.method_932(0.1f))
                        .method_351(class_77.method_411(ItemRegistry.WARDEN_UPGRADE_SMITHING_TEMPLATE.get())
                                .method_438(class_141.method_621(class_44.method_32448(1.0f))));
                class_55.class_56 sculkShellPoolBuilder = class_55.method_347()
                        .method_356(class_219.method_932(0.25f))
                        .method_351(class_77.method_411(ItemRegistry.SCULK_SHELL.get())
                                .method_438(class_141.method_621(class_44.method_32448(1.0f))));
                class_55.class_56 echoShardPoolBuilder = class_55.method_347()
                        .method_356(class_219.method_932(0.5f))
                        .method_351(class_77.method_411(class_1802.field_38746)
                                .method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f))));
                class_55.class_56 echoApplePoolBuilder = class_55.method_347()
                        .method_356(class_219.method_932(0.5f))
                        .method_351(class_77.method_411(ItemRegistry.ECHO_APPLE.get())
                                .method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f))));
                tableBuilder.method_336(templatePoolBuilder);
                tableBuilder.method_336(echoShardPoolBuilder);
                tableBuilder.method_336(echoApplePoolBuilder);
                tableBuilder.method_336(sculkShellPoolBuilder);
            }


            if (SCULK_SHRIEKER_LOOT_LOCATION.equals(key.method_29177())) {
                class_55.class_56 shriekerFangPoolBuilder = class_55.method_347()
                        .method_356(getFortuneConditionBuilder(registries, 0.3f, 0.1f))
                        .method_351(class_77.method_411(ItemRegistry.SHRIEKER_FANG.get()))
                        .method_353(class_141.method_621(class_5662.method_32462(1f, 4f)));
                class_55.class_56 wardenSoulPoolBuilder = class_55.method_347()
                        .method_356(getFortuneConditionBuilder(registries, 0.05f, 0.05f))
                        .method_351(class_77.method_411(ItemRegistry.WARDEN_SOUL.get()))
                        .method_353(class_141.method_621(class_5662.method_32462(1f, 2f)));
                tableBuilder.method_336(shriekerFangPoolBuilder);
                tableBuilder.method_336(wardenSoulPoolBuilder);
            }

            if (WARDEN_LOOT_LOCATION.equals(key.method_29177())) {
                class_55.class_56 wardenSoulPoolBuilder = class_55.method_347()
                        .method_356(class_225.method_953(registries, 0.3f, 0.1f))
                        .method_351(class_77.method_411(ItemRegistry.WARDEN_SOUL.get()))
                        .method_353(class_141.method_621(class_5662.method_32462(1f, 2f)));
                class_55.class_56 wardenTendrilPoolBuilder = class_55.method_347()
                        .method_356(class_225.method_953(registries, 0.4f, 0.1f))
                        .method_351(class_77.method_411(ItemRegistry.WARDEN_TENDRIL.get()))
                        .method_353(class_141.method_621(class_5662.method_32462(1f, 2f)));
                tableBuilder.method_336(wardenSoulPoolBuilder);
                tableBuilder.method_336(wardenTendrilPoolBuilder);
            }
        });
    }

    private static class_5341.class_210 getFortuneConditionBuilder(class_7225.class_7874 registries, float base, float perLevelAfterFirst) {
        class_7225.class_7226<class_1887> registryLookup = registries.method_46762(class_7924.field_41265);
        return () -> new class_225(base, new class_9704.class_9709(base + perLevelAfterFirst, perLevelAfterFirst), registryLookup.method_46747(class_1893.field_9130));
    }
}